/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborTag;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CborSimple
extends CborObject {
    private static final Map<Integer, CborSimple> mSingletons = new ConcurrentHashMap<Integer, CborSimple>();
    private static final int TYPE_TRUE = 21;
    private static final int TYPE_FALSE = 20;
    private static final int TYPE_NULL = 22;
    private static final int TYPE_UNDEFINED_VALUE = 23;
    public static final CborSimple TRUE = CborSimple.create(21);
    public static final CborSimple FALSE = CborSimple.create(20);
    public static final CborSimple NULL = CborSimple.create(22);
    public static final CborSimple UNDEFINED = CborSimple.create(23);
    private int mValue;
    private int mTag;

    public static CborSimple create(int value, int tag) {
        return tag == -1 ? CborSimple.create(value) : new CborSimple(value, tag);
    }

    public static CborSimple create(int value) {
        return mSingletons.computeIfAbsent(value, k -> new CborSimple(value, -1));
    }

    private CborSimple(int value, int tag) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Invalid simple value: out of range: " + value);
        }
        if (value >= 24 && value <= 31) {
            throw new IllegalArgumentException("Reserved simple value " + value);
        }
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mValue = value;
        this.mTag = tag;
    }

    @Override
    public final int getMajorType() {
        return 7;
    }

    @Override
    public final int getAdditionalInformation() {
        int x = this.getValue();
        return x < 24 ? x : 24;
    }

    public int getValue() {
        return this.mValue;
    }

    @Override
    public int getTag() {
        return this.mTag;
    }

    @Override
    public CborSimple copy() {
        return this;
    }

    @Override
    public final boolean isValidJson() {
        switch (this.getValue()) {
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final String toJsonString() {
        int x = this.getValue();
        switch (x) {
            case 21: {
                return "true";
            }
            case 20: {
                return "false";
            }
            case 22: {
                return "null";
            }
            case 23: {
                return "\"undefined\"";
            }
        }
        return "\"simple(" + x + ")\"";
    }

    @Override
    public @Nullable Object toJavaObject() {
        int x = this.getValue();
        switch (x) {
            case 21: {
                return Boolean.TRUE;
            }
            case 20: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (this == NULL || this == UNDEFINED) {
            return null;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            switch (this.getValue()) {
                case 21: {
                    return clazz.cast(Boolean.TRUE);
                }
                case 20: {
                    return clazz.cast(Boolean.FALSE);
                }
            }
            throw new CborConversionException(this + " is not a boolean");
        }
        if (Object.class.equals(clazz)) {
            return null;
        }
        throw new CborConversionException(String.format("%s cannot be converted to a %s", this, clazz));
    }

    public int hashCode() {
        return this.mTag * 257 + this.mValue;
    }

    public boolean equals(Object obj) {
        if (this.mTag == -1) {
            return this == obj;
        }
        if (!(obj instanceof CborSimple)) {
            return false;
        }
        CborSimple rhs = (CborSimple)obj;
        return this.mValue == rhs.mValue && this.mTag == rhs.mTag;
    }

    @Override
    public String toString(int ignore) {
        return this.toString();
    }

    @Override
    public final String toString() {
        String ret;
        switch (this.mValue) {
            case 21: {
                ret = "true";
                break;
            }
            case 20: {
                ret = "false";
                break;
            }
            case 22: {
                ret = "null";
                break;
            }
            case 23: {
                ret = "undefined";
                break;
            }
            default: {
                ret = "simple(" + this.mValue + ")";
            }
        }
        return this.mTag == -1 ? ret : this.mTag + "(" + ret + ")";
    }
}

