/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborByteString;
import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborReader;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTag;
import com.google.iot.cbor.CborTextString;
import com.google.iot.cbor.DecoderStream;
import com.google.iot.cbor.Half;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

class CborReaderImpl
implements CborReader {
    private static final boolean DEBUG = true;
    private static final Logger LOGGER = Logger.getLogger(CborReader.class.getCanonicalName());
    static final int UNSPECIFIED = -1;
    private static final byte BREAK = -1;
    private final DecoderStream mDecoderStream;
    private int mRemainingObjects;
    private int mLastTag = -1;

    private CborReaderImpl(DecoderStream decoderStream, int objectCount) {
        this.mDecoderStream = decoderStream;
        this.mRemainingObjects = objectCount;
    }

    CborReaderImpl(InputStream inputStream, int objectCount) {
        this(DecoderStream.create(inputStream), objectCount);
    }

    CborReaderImpl(byte[] bytes, int offset, int objectCount) {
        this(new ByteArrayInputStream(bytes, offset, bytes.length - offset), objectCount);
        if (offset >= bytes.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean hasRemainingDataItems() {
        try {
            if (this.mRemainingObjects < 0) {
                return this.mDecoderStream.hasRemaining() && this.mDecoderStream.peek() != -1;
            }
            return this.mRemainingObjects != 0;
        }
        catch (EOFException x) {
            return false;
        }
        catch (IOException x) {
            x.printStackTrace();
            return true;
        }
    }

    @Override
    public long bytesParsed() {
        return this.mDecoderStream.bytesParsed();
    }

    @Override
    public CborObject readDataItem() throws CborParseException, IOException {
        if (!this.hasRemainingDataItems()) {
            throw new NoSuchElementException();
        }
        int tag = this.mLastTag;
        this.mLastTag = -1;
        try {
            BigInteger additionalData;
            byte firstByte = this.mDecoderStream.get();
            int majorType = (firstByte & 0xFF) >> 5;
            byte additionalInfo = (byte)(firstByte & 0x1F);
            if (additionalInfo < 24) {
                additionalData = BigInteger.valueOf(additionalInfo);
            } else if (additionalInfo == 24) {
                additionalData = BigInteger.valueOf(this.mDecoderStream.get() & 0xFF);
            } else if (additionalInfo == 25) {
                additionalData = BigInteger.valueOf(this.mDecoderStream.getShort() & 0xFFFF);
            } else if (additionalInfo == 26) {
                additionalData = BigInteger.valueOf((long)this.mDecoderStream.getInt() & 0xFFFFFFFFL);
            } else if (additionalInfo == 27) {
                additionalData = new BigInteger(Long.toUnsignedString(this.mDecoderStream.getLong()));
            } else if (additionalInfo == 31) {
                additionalData = BigInteger.valueOf(-1L);
            } else {
                throw new CborParseException("Undefined additional info value " + additionalInfo + " for major type " + majorType);
            }
            switch (majorType) {
                case 6: {
                    if (CborTag.isValid(additionalData.longValue())) {
                        this.mLastTag = (int)additionalData.longValue();
                    } else {
                        LOGGER.warning("Ignoring invalid tag: " + additionalData);
                    }
                    return this.readDataItem();
                }
                case 0: {
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return CborInteger.create(additionalData, tag, 0);
                }
                case 1: {
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return CborInteger.create(BigInteger.valueOf(-1L).subtract(additionalData), tag, 1);
                }
                case 2: {
                    if (additionalData.compareTo(BigInteger.ZERO) < 0) {
                        ArrayList aggregator = new ArrayList();
                        CborReaderImpl subparser = new CborReaderImpl(this.mDecoderStream, additionalData.intValue());
                        while (subparser.hasRemainingDataItems()) {
                            CborObject obj = subparser.readDataItem();
                            if (obj instanceof CborByteString && obj.getMajorType() == 2) {
                                aggregator.addAll(Arrays.asList(((CborByteString)obj).byteArrayValue()));
                                continue;
                            }
                            throw new CborParseException("Unexpected major type in byte string stream");
                        }
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        if (this.mDecoderStream.get() != -1) {
                            throw new CborParseException("Missing break");
                        }
                        return CborByteString.wrap((byte[][])aggregator.toArray((T[])new byte[0][]), tag, true);
                    }
                    if (BigInteger.valueOf(additionalData.intValue()).equals(additionalData)) {
                        byte[] bytes = new byte[additionalData.intValue()];
                        this.mDecoderStream.get(bytes);
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        return CborByteString.wrap(BigArrays.wrap((byte[])bytes), tag, false);
                    }
                    byte[][] bytes = ByteBigArrays.newBigArray((long)additionalData.longValue());
                    this.mDecoderStream.get(bytes);
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return CborByteString.wrap(bytes, tag, false);
                }
                case 3: {
                    if (additionalData.compareTo(BigInteger.ZERO) < 0) {
                        ArrayList aggregator = new ArrayList();
                        CborReaderImpl subparser = new CborReaderImpl(this.mDecoderStream, additionalData.intValue());
                        while (subparser.hasRemainingDataItems()) {
                            CborObject obj = subparser.readDataItem();
                            if (obj instanceof CborTextString) {
                                aggregator.addAll(Arrays.asList(((CborTextString)obj).byteArrayValue()));
                                continue;
                            }
                            throw new CborParseException("Unexpected major type in text string stream");
                        }
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        if (this.mDecoderStream.get() != -1) {
                            throw new CborParseException("Missing break");
                        }
                        byte[][] bytes = (byte[][])aggregator.toArray((T[])new byte[0][]);
                        int[] offsets = new int[bytes.length];
                        int[] lengths = new int[bytes.length];
                        for (int i = 0; i < bytes.length; ++i) {
                            offsets[i] = 0;
                            lengths[i] = bytes[i].length;
                        }
                        return CborTextString.create(bytes, offsets, lengths, tag, true);
                    }
                    byte[] bytes = new byte[additionalData.intValue()];
                    this.mDecoderStream.get(bytes);
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return CborTextString.create(bytes, 0, bytes.length, tag, false);
                }
                case 4: {
                    boolean isIndefiniteLength = additionalData.compareTo(BigInteger.valueOf(-1L)) == 0;
                    CborArray ret = CborArray.create(null, tag, isIndefiniteLength);
                    CborReaderImpl subparser = new CborReaderImpl(this.mDecoderStream, additionalData.intValue());
                    while (subparser.hasRemainingDataItems()) {
                        ret.add(subparser.readDataItem());
                    }
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    if (isIndefiniteLength && this.mDecoderStream.get() != -1) {
                        throw new CborParseException("Missing break");
                    }
                    return ret;
                }
                case 5: {
                    boolean isIndefiniteLength = additionalData.compareTo(BigInteger.valueOf(-1L)) == 0;
                    CborMap ret = CborMap.create(null, tag, isIndefiniteLength);
                    if (!isIndefiniteLength) {
                        additionalData = additionalData.multiply(BigInteger.valueOf(2L));
                    }
                    CborReaderImpl subparser = new CborReaderImpl(this.mDecoderStream, additionalData.intValue());
                    while (subparser.hasRemainingDataItems()) {
                        CborObject key = subparser.readDataItem();
                        CborObject value = subparser.readDataItem();
                        ret.mapValue().put(key, value);
                    }
                    if (additionalData.compareTo(BigInteger.valueOf(-1L)) == 0 && this.mDecoderStream.get() != -1) {
                        throw new CborParseException("Missing break");
                    }
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return ret;
                }
                case 7: {
                    if (additionalInfo == 25) {
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        return CborFloat.createHalf(Half.shortBitsToFloat(additionalData.shortValue()), tag);
                    }
                    if (additionalInfo == 26) {
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        return CborFloat.create(Float.intBitsToFloat(additionalData.intValue()), tag);
                    }
                    if (additionalInfo == 27) {
                        if (this.mRemainingObjects != -1) {
                            --this.mRemainingObjects;
                        }
                        return CborFloat.create(Double.longBitsToDouble(additionalData.longValue()), tag);
                    }
                    if (this.mRemainingObjects != -1) {
                        --this.mRemainingObjects;
                    }
                    return CborSimple.create(additionalData.intValue(), tag);
                }
            }
            throw new CborParseException("Invalid major type value " + majorType);
        }
        catch (EOFException | IllegalArgumentException | BufferUnderflowException | NoSuchElementException x) {
            throw new CborParseException("CBOR data is truncated or corrupt", x);
        }
    }
}

