/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborArray;
import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMapImpl;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTextString;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CborMap
extends CborObject {
    CborMap() {
    }

    public static CborMap createFromCborByteArray(byte[] input, int offset, int length) throws CborParseException {
        CborObject obj = CborObject.createFromCborByteArray(input, offset, length);
        if (obj instanceof CborMap) {
            return (CborMap)obj;
        }
        throw new CborParseException("Not a map");
    }

    public static CborMap createFromCborByteArray(byte[] input) throws CborParseException {
        return CborMap.createFromCborByteArray(input, 0, input.length);
    }

    public static CborMap createFromJavaObject(Map<?, ?> obj) throws CborConversionException {
        CborMap map = CborMap.create();
        for (Map.Entry<?, ?> entry : obj.entrySet()) {
            map.mapValue().put(CborObject.createFromJavaObject(entry.getKey()), CborObject.createFromJavaObject(entry.getValue()));
        }
        return map;
    }

    public static CborMap create(int tag) {
        return new CborMapImpl(tag);
    }

    public static CborMap create(Map<CborObject, CborObject> map, int tag) {
        return new CborMapImpl(map, tag);
    }

    public static CborMap create(Map<CborObject, CborObject> map, int tag, boolean isIndefiniteLength) {
        return new CborMapImpl(map, tag, isIndefiniteLength);
    }

    public static CborMap create(Map<CborObject, CborObject> map) {
        return CborMap.create(map, -1);
    }

    public static CborMap createFromJSONObject(JSONObject obj) {
        CborMap map = CborMap.create();
        for (String key : obj.keySet()) {
            CborObject value;
            if (obj.isNull(key)) {
                value = CborSimple.NULL;
            } else {
                Object rawValue = obj.get(key);
                if (rawValue instanceof JSONArray) {
                    value = CborArray.createFromJSONArray((JSONArray)rawValue);
                } else if (rawValue instanceof JSONObject) {
                    value = CborMap.createFromJSONObject((JSONObject)rawValue);
                } else {
                    try {
                        value = CborObject.createFromJavaObject(rawValue);
                    }
                    catch (CborConversionException x) {
                        throw new CborRuntimeException(x);
                    }
                }
            }
            map.put(key, value);
        }
        return map;
    }

    public static CborMap create() {
        return CborMap.create(-1);
    }

    public abstract Map<CborObject, CborObject> mapValue();

    public int size() {
        return this.mapValue().size();
    }

    public boolean isEmpty() {
        return this.mapValue().isEmpty();
    }

    @CanIgnoreReturnValue
    public CborObject remove(CborObject key) {
        return this.mapValue().remove(key);
    }

    public void clear() {
        this.mapValue().clear();
    }

    public Set<Map.Entry<CborObject, CborObject>> entrySet() {
        return this.mapValue().entrySet();
    }

    public Set<CborObject> keySet() {
        return this.mapValue().keySet();
    }

    public CborObject get(CborObject key) {
        return this.mapValue().get(key);
    }

    public final CborObject get(String key) {
        return this.mapValue().get(CborTextString.create(key));
    }

    public final boolean containsKey(String key) {
        return this.mapValue().containsKey(CborTextString.create(key));
    }

    @CanIgnoreReturnValue
    public final CborObject put(String key, CborObject value) {
        return this.mapValue().put(CborTextString.create(key), value);
    }

    @CanIgnoreReturnValue
    public final CborObject remove(String key) {
        return this.mapValue().remove(CborTextString.create(key));
    }

    public final Set<String> keySetAsStrings() throws CborConversionException {
        HashSet<String> ret = new HashSet<String>();
        for (CborObject key : this.mapValue().keySet()) {
            if (!(key instanceof CborTextString)) {
                throw new CborConversionException("Key is not a string");
            }
            ret.add(((CborTextString)key).stringValue());
        }
        return ret;
    }

    public final boolean areAllKeysStrings() {
        for (CborObject key : this.mapValue().keySet()) {
            if (key instanceof CborTextString) continue;
            return false;
        }
        return true;
    }

    public final Map<String, Object> toNormalMap() throws CborConversionException {
        if (!this.areAllKeysStrings()) {
            throw new CborConversionException("Not all keys are strings");
        }
        return this.toJavaObject();
    }

    @Override
    public final int getMajorType() {
        return 5;
    }

    @Override
    public final int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(BigInteger.valueOf(this.mapValue().size()));
    }

    public abstract boolean isIndefiniteLength();

    @Override
    public final Map<Object, Object> toJavaObject() {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
            ret.put(entry.getKey().toJavaObject(), entry.getValue().toJavaObject());
        }
        return ret;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (clazz.isAssignableFrom(Map.class)) {
            LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
            for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
                ret.put(entry.getKey().toJavaObject(Object.class), entry.getValue().toJavaObject(Object.class));
            }
            return clazz.cast(ret);
        }
        throw new CborConversionException(clazz + " is not assignable from map");
    }

    @Override
    public final CborMap copy() {
        CborMap ret = CborMap.create(this.getTag());
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
            ret.mapValue().put(entry.getKey().copy(), entry.getValue().copy());
        }
        return ret;
    }

    @Override
    public final boolean isValidJson() {
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
            if (!(entry.getKey() instanceof CborTextString)) {
                return false;
            }
            if (entry.getValue().isValidJson()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toJsonString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (entry.getKey() instanceof CborTextString) {
                sb.append(entry.getKey().toJsonString());
            } else {
                sb.append(JSONObject.quote((String)entry.getKey().toJsonString()));
            }
            sb.append(":");
            sb.append(entry.getValue().toJsonString());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return Integer.hashCode(this.getTag()) * 1337 + this.mapValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborMap)) {
            return false;
        }
        CborMap rhs = (CborMap)obj;
        return rhs.getTag() == this.getTag() && this.mapValue().equals(rhs.mapValue());
    }

    @Override
    public String toString(int indentLevel) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        if (indentLevel >= 0) {
            ++indentLevel;
        }
        for (Map.Entry<CborObject, CborObject> entry : this.mapValue().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (indentLevel >= 0) {
                sb.append("\n");
                for (int i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
            }
            sb.append(entry.getKey().toString(indentLevel));
            sb.append(":");
            sb.append(entry.getValue().toString(indentLevel));
        }
        if (!this.isEmpty() && indentLevel > 0) {
            --indentLevel;
            sb.append("\n");
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
        }
        sb.append("}");
        int tag = this.getTag();
        return tag == -1 ? sb.toString() : tag + "(" + sb.toString() + ")";
    }
}

