/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.iot.cbor.CborArrayImpl;
import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborFloat;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborRuntimeException;
import com.google.iot.cbor.CborSimple;
import com.google.iot.cbor.CborTag;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CborArray
extends CborObject
implements Iterable<CborObject> {
    CborArray() {
    }

    public static CborArray create() {
        return new CborArrayImpl();
    }

    public static CborArray create(int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        return new CborArrayImpl(null, tag, false);
    }

    public static CborArray create(Iterable<CborObject> objs) {
        return CborArray.create(objs, -1);
    }

    public static CborArray create(Iterable<CborObject> objs, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        return new CborArrayImpl(objs, tag, false);
    }

    public static CborArray create(Iterable<CborObject> objs, int tag, boolean isIndefiniteLength) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        return new CborArrayImpl(objs, tag, isIndefiniteLength);
    }

    public static CborArray createFromJavaObject(Iterable<?> obj) throws CborConversionException {
        CborArray array = CborArray.create();
        for (Object value : obj) {
            array.add(CborObject.createFromJavaObject(value));
        }
        return array;
    }

    public static CborArray createFromJavaObject(Object[] obj) throws CborConversionException {
        CborArray array = CborArray.create();
        for (Object value : obj) {
            array.add(CborObject.createFromJavaObject(value));
        }
        return array;
    }

    public static CborArray createFromJavaObject(int[] obj) {
        CborArray array = CborArray.create();
        for (int value : obj) {
            array.add(CborInteger.create(BigInteger.valueOf(value)));
        }
        return array;
    }

    public static CborArray createFromJavaObject(short[] obj) {
        CborArray array = CborArray.create();
        for (short value : obj) {
            array.add(CborInteger.create(BigInteger.valueOf(value)));
        }
        return array;
    }

    public static CborArray createFromJavaObject(long[] obj) {
        CborArray array = CborArray.create();
        for (long value : obj) {
            array.add(CborInteger.create(BigInteger.valueOf(value)));
        }
        return array;
    }

    public static CborArray createFromJavaObject(boolean[] obj) {
        CborArray array = CborArray.create();
        for (boolean value : obj) {
            array.add(value ? CborSimple.TRUE : CborSimple.FALSE);
        }
        return array;
    }

    public static CborArray createFromJavaObject(float[] obj) {
        CborArray array = CborArray.create();
        for (float value : obj) {
            array.add(CborFloat.create(value));
        }
        return array;
    }

    public static CborArray createFromJavaObject(double[] obj) {
        CborArray array = CborArray.create();
        for (double value : obj) {
            array.add(CborFloat.create(value));
        }
        return array;
    }

    public static CborArray createFromJSONArray(JSONArray jsonArray) {
        CborArray ret = CborArray.create();
        for (int i = 0; i < jsonArray.length(); ++i) {
            CborObject value;
            if (jsonArray.isNull(i)) {
                value = CborSimple.NULL;
            } else {
                Object rawValue = jsonArray.get(i);
                if (rawValue instanceof JSONArray) {
                    value = CborArray.createFromJSONArray((JSONArray)rawValue);
                } else if (rawValue instanceof JSONObject) {
                    value = CborMap.createFromJSONObject((JSONObject)rawValue);
                } else {
                    try {
                        value = CborObject.createFromJavaObject(rawValue);
                    }
                    catch (CborConversionException x) {
                        throw new CborRuntimeException(x);
                    }
                }
            }
            ret.add(value);
        }
        return ret;
    }

    public abstract List<CborObject> listValue();

    public int size() {
        return this.listValue().size();
    }

    public boolean isEmpty() {
        return this.listValue().isEmpty();
    }

    public void add(CborObject cborObject) {
        this.listValue().add(cborObject);
    }

    @CanIgnoreReturnValue
    public boolean remove(CborObject cborObject) {
        return this.listValue().remove(cborObject);
    }

    public void clear() {
        this.listValue().clear();
    }

    @Override
    public final int getMajorType() {
        return 4;
    }

    @Override
    public final int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(BigInteger.valueOf(this.size()));
    }

    public abstract boolean isIndefiniteLength();

    @Override
    public boolean isValidJson() {
        for (CborObject item : this) {
            if (item.isValidJson()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toJsonString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (CborObject obj : this) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(obj.toJsonString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<Object> toJavaObject() {
        ArrayList<Object> ret = new ArrayList<Object>();
        this.forEach(x -> ret.add(x.toJavaObject()));
        return ret;
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        if (clazz.isAssignableFrom(List.class)) {
            return clazz.cast(this.toJavaObject());
        }
        if (clazz.isAssignableFrom(float[].class)) {
            float[] array = new float[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                Float v = iter.next().toJavaObject(Float.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v.floatValue();
            }
            return clazz.cast(array);
        }
        if (clazz.isAssignableFrom(double[].class)) {
            double[] array = new double[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                Double v = iter.next().toJavaObject(Double.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v;
            }
            return clazz.cast(array);
        }
        if (clazz.isAssignableFrom(int[].class)) {
            int[] array = new int[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                Integer v = iter.next().toJavaObject(Integer.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v;
            }
            return clazz.cast(array);
        }
        if (clazz.isAssignableFrom(short[].class)) {
            short[] array = new short[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                Short v = iter.next().toJavaObject(Short.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v;
            }
            return clazz.cast(array);
        }
        if (clazz.isAssignableFrom(long[].class)) {
            long[] array = new long[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                Long v = iter.next().toJavaObject(Long.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v;
            }
            return clazz.cast(array);
        }
        if (clazz.isAssignableFrom(String[].class)) {
            String[] array = new String[this.size()];
            Iterator<CborObject> iter = this.iterator();
            for (int i = 0; i < this.size(); ++i) {
                String v = iter.next().toJavaObject(String.class);
                if (v == null) {
                    throw new CborConversionException("element is not assignable from null");
                }
                array[i] = v;
            }
            return clazz.cast(array);
        }
        throw new CborConversionException(clazz + " is not assignable from array");
    }

    @Override
    public CborArray copy() {
        CborArray ret = CborArray.create(this.getTag());
        for (CborObject obj : this) {
            ret.add(obj.copy());
        }
        return ret;
    }

    @Override
    public @NonNull Iterator<CborObject> iterator() {
        return this.listValue().iterator();
    }

    public int hashCode() {
        return Integer.hashCode(this.getTag()) * 1337 + this.listValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborArray)) {
            return false;
        }
        CborArray rhs = (CborArray)obj;
        return rhs.getTag() == this.getTag() && this.listValue().equals(rhs.listValue());
    }

    @Override
    public final String toString(int indentLevel) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        if (indentLevel >= 0) {
            ++indentLevel;
        }
        for (CborObject obj : this) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (indentLevel >= 0) {
                sb.append("\n");
                for (int i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
            }
            sb.append(obj.toString(indentLevel));
        }
        if (!this.isEmpty() && indentLevel > 0) {
            --indentLevel;
            sb.append("\n");
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
        }
        sb.append("]");
        int tag = this.getTag();
        return tag == -1 ? sb.toString() : tag + "(" + sb.toString() + ")";
    }
}

