/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborTag;
import com.google.iot.cbor.CborTextString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class CborTextStringImpl
extends CborTextString {
    private final String mValue;
    private final byte[] mByteValue;
    private final int mTag;

    @Override
    public int getTag() {
        return this.mTag;
    }

    CborTextStringImpl(String value, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = value;
        this.mByteValue = this.mValue.getBytes(StandardCharsets.UTF_8);
    }

    CborTextStringImpl(byte[] array, int offset, int length, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mTag = tag;
        this.mValue = new String(array, offset, length, StandardCharsets.UTF_8);
        this.mByteValue = Arrays.copyOfRange(array, offset, offset + length);
    }

    @Override
    public String stringValue() {
        return this.mValue;
    }

    @Override
    public byte[] byteArrayValue() {
        return this.mByteValue;
    }
}

