/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborMap;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborTag;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class CborMapImpl
extends CborMap {
    private final Map<CborObject, CborObject> mMap;
    private int mTag;
    private boolean mIsIndefiniteLength;

    CborMapImpl(int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        this.mMap = new LinkedHashMap<CborObject, CborObject>();
        this.mTag = tag;
        this.mIsIndefiniteLength = false;
    }

    CborMapImpl(Map<CborObject, CborObject> map, int tag) {
        this(tag);
        this.mMap.putAll(map);
        this.mIsIndefiniteLength = false;
    }

    CborMapImpl(@Nullable Map<CborObject, CborObject> map, int tag, boolean isIndefiniteLength) {
        this(tag);
        if (map != null) {
            this.mMap.putAll(map);
        }
        this.mIsIndefiniteLength = isIndefiniteLength;
    }

    @Override
    public int getTag() {
        return this.mTag;
    }

    @Override
    public Map<CborObject, CborObject> mapValue() {
        return this.mMap;
    }

    @Override
    public boolean isIndefiniteLength() {
        return this.mIsIndefiniteLength;
    }
}

