/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborByteStringImpl;
import com.google.iot.cbor.CborConversionException;
import com.google.iot.cbor.CborInteger;
import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborTag;
import it.unimi.dsi.fastutil.BigArrays;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Base64;

public abstract class CborByteString
extends CborObject {
    CborByteString() {
    }

    public static CborByteString wrap(byte[][] array, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        return new CborByteStringImpl(array, tag);
    }

    public static CborByteString create(byte[][] array, long offset, long length, int tag) {
        if (!CborTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag value " + tag);
        }
        return new CborByteStringImpl(array, offset, length, tag);
    }

    public static CborByteString create(byte[] array, int offset, int length, int tag) {
        return CborByteString.create(BigArrays.wrap((byte[])array), (long)offset, (long)length, tag);
    }

    public static CborByteString create(byte[] array, int offset, int length) {
        return CborByteString.create(array, offset, length, -1);
    }

    public static CborByteString create(byte[] array) {
        return CborByteString.create(array, 0, array.length);
    }

    public abstract byte[][] byteArrayValue();

    @Override
    public int getMajorType() {
        return 2;
    }

    @Override
    public int getAdditionalInformation() {
        return CborInteger.calcAdditionalInformation(BigInteger.valueOf(this.byteArrayValue().length));
    }

    @Override
    public boolean isValidJson() {
        switch (this.getTag()) {
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    private String toBase16String() {
        StringBuilder ret = new StringBuilder();
        long length = BigArrays.length((byte[][])this.byteArrayValue());
        for (long i = 0L; i < length; ++i) {
            ret.append(String.format("%02x", BigArrays.get((byte[][])this.byteArrayValue(), (long)i)));
        }
        return ret.toString();
    }

    @Override
    public String toJsonString() {
        if (this.getTag() == 23) {
            return "\"" + this.toBase16String() + "\"";
        }
        return "\"" + Base64.getEncoder().encodeToString(this.byteArrayValue()[0]) + "\"";
    }

    public byte[] toJavaObject() {
        byte[][] value = this.byteArrayValue();
        return Arrays.copyOf(value[0], value[0].length);
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) throws CborConversionException {
        CborConversionException lastException = null;
        switch (this.getTag()) {
            case 2: {
                if (!clazz.isAssignableFrom(BigInteger.class)) break;
                return clazz.cast(new BigInteger(1, this.byteArrayValue()[0]));
            }
            case 3: {
                if (!clazz.isAssignableFrom(BigInteger.class)) break;
                return clazz.cast(new BigInteger(-1, this.byteArrayValue()[0]));
            }
            case 23: {
                if (!clazz.isAssignableFrom(String.class)) break;
                return clazz.cast(this.toBase16String());
            }
            case 22: {
                if (!clazz.isAssignableFrom(String.class)) break;
                clazz.cast(Base64.getEncoder().encodeToString(this.byteArrayValue()[0]));
                break;
            }
            case 24: {
                if (!CborObject.class.isAssignableFrom(clazz) && !clazz.isAssignableFrom(String.class)) break;
                try {
                    CborObject obj = CborObject.createFromCborByteArray(this.byteArrayValue()[0]);
                    if (clazz.isAssignableFrom(obj.getClass())) {
                        return clazz.cast(obj);
                    }
                    lastException = new CborConversionException(clazz + " is not assignable from " + obj.getClass());
                    break;
                }
                catch (CborParseException e) {
                    lastException = new CborConversionException(e);
                }
            }
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return clazz.cast(this.toJavaObject());
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new CborConversionException(clazz + " is not assignable from byte string");
    }

    @Override
    public CborByteString copy() {
        byte[][] array = this.byteArrayValue();
        return CborByteString.create(array, 0L, BigArrays.length((byte[][])array), this.getTag());
    }

    public int hashCode() {
        return Integer.hashCode(this.getTag()) * 1337 + Arrays.deepHashCode((Object[])this.byteArrayValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CborByteString)) {
            return false;
        }
        CborByteString rhs = (CborByteString)obj;
        return this.getTag() == rhs.getTag() && Arrays.deepEquals((Object[])this.byteArrayValue(), (Object[])rhs.byteArrayValue());
    }

    @Override
    public String toString(int ignore) {
        return this.toString();
    }

    @Override
    public String toString() {
        String ret = "h'" + this.toBase16String() + "'";
        int tag = this.getTag();
        return tag == -1 ? ret : tag + "(" + ret + ")";
    }
}

