/*
 * Copyright (C) 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.iot.cbor;

import it.unimi.dsi.fastutil.BigArrays;

final class CborByteStringImpl extends CborByteString {
    private final byte[][] mByteValue;
    private final int mTag;

    @Override
    public int getTag() {
        return mTag;
    }

    CborByteStringImpl(byte[][] array, long offset, long length, int tag) {
        mTag = tag;
        mByteValue = BigArrays.copy(array, offset, length);
    }

    CborByteStringImpl(byte[][] array, int tag) {
        // simple wrap
        mTag = tag;
        mByteValue = array;
    }

    @Override
    public byte[][] byteArrayValue() {
        return mByteValue;
    }
}
