/*
 * Decompiled with CFR 0.152.
 */
package com.google.iot.cbor;

import com.google.iot.cbor.CborObject;
import com.google.iot.cbor.CborParseException;
import com.google.iot.cbor.CborReaderImpl;
import java.io.IOException;
import java.io.InputStream;

public interface CborReader {
    public static CborReader createFromInputStream(InputStream inputStream, int objectCount) {
        return new CborReaderImpl(inputStream, objectCount);
    }

    public static CborReader createFromInputStream(InputStream inputStream) {
        return CborReader.createFromInputStream(inputStream, -1);
    }

    public static CborReader createFromByteArray(byte[] bytes, int offset, int objectCount) {
        return new CborReaderImpl(bytes, offset, objectCount);
    }

    public static CborReader createFromByteArray(byte[] bytes, int offset) {
        return CborReader.createFromByteArray(bytes, offset, -1);
    }

    public static CborReader createFromByteArray(byte[] bytes) {
        return CborReader.createFromByteArray(bytes, 0);
    }

    public boolean hasRemainingDataItems();

    public CborObject readDataItem() throws CborParseException, IOException;

    public long bytesParsed();
}

