/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.dns.TcpDnsQueryDecoder;
import io.netty.handler.codec.dns.TcpDnsQueryEncoder;
import io.netty.handler.codec.dns.TcpDnsResponseEncoder;
import io.netty.util.ReferenceCountUtil;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TcpDnsTest {
    private static final String QUERY_DOMAIN = "www.example.com";
    private static final long TTL = 600L;
    private static final byte[] QUERY_RESULT = new byte[]{-64, -88, 1, 1};

    @Test
    public void testQueryDecode() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsQueryDecoder()});
        int randomID = new Random().nextInt(59000) + 1000;
        DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{query}));
        DnsQuery readQuery = (DnsQuery)channel.readInbound();
        Assertions.assertEquals((Object)query, (Object)readQuery);
        Assertions.assertEquals((Object)query.recordAt(DnsSection.QUESTION).name(), (Object)readQuery.recordAt(DnsSection.QUESTION).name());
        readQuery.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testDecoderLeak() {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsQueryDecoder()});
        EmbeddedChannel encoder = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsQueryEncoder()});
        int randomID = new Random().nextInt(59000) + 1000;
        DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
        Assertions.assertTrue((boolean)encoder.writeOutbound(new Object[]{query}));
        ByteBuf encoded = (ByteBuf)encoder.readOutbound();
        Assertions.assertTrue((boolean)decoder.writeInbound(new Object[]{encoded}));
        DnsQuery decoded = (DnsQuery)decoder.readInbound();
        Assertions.assertEquals((Object)query, (Object)decoded);
        ReferenceCountUtil.release((Object)decoded);
        Assertions.assertTrue((encoded.refCnt() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)encoder.finish());
        Assertions.assertFalse((boolean)decoder.finish());
    }

    @Test
    public void testResponseEncode() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new TcpDnsResponseEncoder()});
        int randomID = new Random().nextInt(59000) + 1000;
        DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
        DnsQuestion question = (DnsQuestion)query.recordAt(DnsSection.QUESTION);
        channel.writeInbound(new Object[]{TcpDnsTest.newResponse(query, question, new byte[][]{QUERY_RESULT})});
        DnsResponse readResponse = (DnsResponse)channel.readInbound();
        Assertions.assertEquals((Object)question, (Object)readResponse.recordAt(DnsSection.QUESTION));
        DefaultDnsRawRecord record = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, 600L, Unpooled.wrappedBuffer((byte[])QUERY_RESULT));
        Assertions.assertEquals((Object)record, (Object)readResponse.recordAt(DnsSection.ANSWER));
        Assertions.assertEquals((Object)record.content(), (Object)((DnsRawRecord)readResponse.recordAt(DnsSection.ANSWER)).content());
        ReferenceCountUtil.release((Object)readResponse);
        ReferenceCountUtil.release((Object)record);
        query.release();
        Assertions.assertFalse((boolean)channel.finish());
    }

    private static DefaultDnsResponse newResponse(DnsQuery query, DnsQuestion question, byte[] ... addresses) {
        DefaultDnsResponse response = new DefaultDnsResponse(query.id());
        response.addRecord(DnsSection.QUESTION, (DnsRecord)question);
        for (byte[] address : addresses) {
            DefaultDnsRawRecord queryAnswer = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, 600L, Unpooled.wrappedBuffer((byte[])address));
            response.addRecord(DnsSection.ANSWER, (DnsRecord)queryAnswer);
        }
        return response;
    }
}

