/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.styleguide.ui;

import io.neos.fusion4j.lang.annotation.FusionApi;
import io.neos.fusion4j.lang.model.FusionPackageName;
import io.neos.fusion4j.runtime.model.FusionDataStructure;
import io.neos.fusion4j.styleguide.ui.StyleguideRouterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u0000 12\u00020\u0001:\u0006123456B[\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c2\u0003J\t\u0010%\u001a\u00020\tH\u00c2\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c2\u0003J\u0015\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0003J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0007Jk\u0010*\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\fH\u00d6\u0001R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter;", "", "routes", "Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Route;", "currentRoute", "routeDefinitions", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteDefinition;", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "routesByUrl", "", "", "routesByName", "(Lio/neos/fusion4j/runtime/model/FusionDataStructure;Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Route;Lio/neos/fusion4j/runtime/model/FusionDataStructure;Ljavax/servlet/http/HttpServletRequest;Ljava/util/Map;Ljava/util/Map;)V", "getCurrentRoute$annotations", "()V", "getCurrentRoute", "()Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Route;", "referrer", "getReferrer$annotations", "getReferrer", "()Ljava/lang/String;", "referrerUrl", "getReferrerUrl$annotations", "getReferrerUrl", "requestUri", "getRequestUri$annotations", "getRequestUri", "getRoutes$annotations", "getRoutes", "()Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "getRoutesByName", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "componentPackageRouteUrl", "packageName", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Route", "RouteDefinition", "RouteNames", "RouteUrls", "Routes", "styleguide"})
public final class StyleguideRouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FusionDataStructure<Route> routes;
    @Nullable
    private final Route currentRoute;
    @NotNull
    private final FusionDataStructure<RouteDefinition> routeDefinitions;
    @NotNull
    private final HttpServletRequest httpRequest;
    @NotNull
    private final Map<String, Route> routesByUrl;
    @NotNull
    private final Map<String, Route> routesByName;
    @NotNull
    private final String requestUri;
    @Nullable
    private final String referrerUrl;
    @Nullable
    private final String referrer;

    public StyleguideRouter(@NotNull FusionDataStructure<Route> routes, @Nullable Route currentRoute2, @NotNull FusionDataStructure<RouteDefinition> routeDefinitions, @NotNull HttpServletRequest httpRequest, @NotNull Map<String, Route> routesByUrl, @NotNull Map<String, Route> routesByName) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Intrinsics.checkNotNullParameter(routeDefinitions, (String)"routeDefinitions");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter(routesByUrl, (String)"routesByUrl");
        Intrinsics.checkNotNullParameter(routesByName, (String)"routesByName");
        this.routes = routes;
        this.currentRoute = currentRoute2;
        this.routeDefinitions = routeDefinitions;
        this.httpRequest = httpRequest;
        this.routesByUrl = routesByUrl;
        this.routesByName = routesByName;
        String string = this.httpRequest.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpRequest.requestURI");
        this.requestUri = string;
        this.referrer = this.referrerUrl = this.httpRequest.getHeader("Referer");
    }

    @NotNull
    public final FusionDataStructure<Route> getRoutes() {
        return this.routes;
    }

    @FusionApi
    public static /* synthetic */ void getRoutes$annotations() {
    }

    @Nullable
    public final Route getCurrentRoute() {
        return this.currentRoute;
    }

    @FusionApi
    public static /* synthetic */ void getCurrentRoute$annotations() {
    }

    @NotNull
    public final Map<String, Route> getRoutesByName() {
        return this.routesByName;
    }

    @NotNull
    public final String getRequestUri() {
        return this.requestUri;
    }

    @FusionApi
    public static /* synthetic */ void getRequestUri$annotations() {
    }

    @Nullable
    public final String getReferrerUrl() {
        return this.referrerUrl;
    }

    @FusionApi
    public static /* synthetic */ void getReferrerUrl$annotations() {
    }

    @Nullable
    public final String getReferrer() {
        return this.referrer;
    }

    @FusionApi
    public static /* synthetic */ void getReferrer$annotations() {
    }

    @FusionApi
    @NotNull
    public final String componentPackageRouteUrl(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String packageRouteName = RouteNames.Companion.packageNameToRouteName$styleguide(packageName);
        Route route = this.routesByName.get(packageRouteName);
        if (route == null) {
            throw new IllegalArgumentException("Could not create route to styleguide component package '" + packageName + "'; route '" + packageRouteName + "' does not exist");
        }
        Route route2 = route;
        return route2.getUrl();
    }

    @NotNull
    public final FusionDataStructure<Route> component1() {
        return this.routes;
    }

    @Nullable
    public final Route component2() {
        return this.currentRoute;
    }

    private final FusionDataStructure<RouteDefinition> component3() {
        return this.routeDefinitions;
    }

    private final HttpServletRequest component4() {
        return this.httpRequest;
    }

    private final Map<String, Route> component5() {
        return this.routesByUrl;
    }

    @NotNull
    public final Map<String, Route> component6() {
        return this.routesByName;
    }

    @NotNull
    public final StyleguideRouter copy(@NotNull FusionDataStructure<Route> routes, @Nullable Route currentRoute2, @NotNull FusionDataStructure<RouteDefinition> routeDefinitions, @NotNull HttpServletRequest httpRequest, @NotNull Map<String, Route> routesByUrl, @NotNull Map<String, Route> routesByName) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Intrinsics.checkNotNullParameter(routeDefinitions, (String)"routeDefinitions");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter(routesByUrl, (String)"routesByUrl");
        Intrinsics.checkNotNullParameter(routesByName, (String)"routesByName");
        return new StyleguideRouter(routes, currentRoute2, routeDefinitions, httpRequest, routesByUrl, routesByName);
    }

    public static /* synthetic */ StyleguideRouter copy$default(StyleguideRouter styleguideRouter, FusionDataStructure fusionDataStructure, Route route, FusionDataStructure fusionDataStructure2, HttpServletRequest httpServletRequest, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            fusionDataStructure = styleguideRouter.routes;
        }
        if ((n & 2) != 0) {
            route = styleguideRouter.currentRoute;
        }
        if ((n & 4) != 0) {
            fusionDataStructure2 = styleguideRouter.routeDefinitions;
        }
        if ((n & 8) != 0) {
            httpServletRequest = styleguideRouter.httpRequest;
        }
        if ((n & 0x10) != 0) {
            map = styleguideRouter.routesByUrl;
        }
        if ((n & 0x20) != 0) {
            map2 = styleguideRouter.routesByName;
        }
        return styleguideRouter.copy(fusionDataStructure, route, fusionDataStructure2, httpServletRequest, map, map2);
    }

    @NotNull
    public String toString() {
        return "StyleguideRouter(routes=" + this.routes + ", currentRoute=" + this.currentRoute + ", routeDefinitions=" + this.routeDefinitions + ", httpRequest=" + this.httpRequest + ", routesByUrl=" + this.routesByUrl + ", routesByName=" + this.routesByName + ")";
    }

    public int hashCode() {
        int result = this.routes.hashCode();
        result = result * 31 + (this.currentRoute == null ? 0 : this.currentRoute.hashCode());
        result = result * 31 + this.routeDefinitions.hashCode();
        result = result * 31 + this.httpRequest.hashCode();
        result = result * 31 + ((Object)this.routesByUrl).hashCode();
        result = result * 31 + ((Object)this.routesByName).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StyleguideRouter)) {
            return false;
        }
        StyleguideRouter styleguideRouter = (StyleguideRouter)other;
        if (!Intrinsics.areEqual(this.routes, styleguideRouter.routes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentRoute, (Object)styleguideRouter.currentRoute)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.routeDefinitions, styleguideRouter.routeDefinitions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.httpRequest, (Object)styleguideRouter.httpRequest)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.routesByUrl, styleguideRouter.routesByUrl)) {
            return false;
        }
        return Intrinsics.areEqual(this.routesByName, styleguideRouter.routesByName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u00a8\u0006\u0003"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteNames;", "", "Companion", "styleguide"})
    public static interface RouteNames {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String OVERVIEW = "overview";
        @NotNull
        public static final String STYLEGUIDE = "styleguide";
        @NotNull
        public static final String FUSION_MODEL = "fusion";
        @NotNull
        public static final String FUSION_MODEL_PROTOTYPE_STORE = "fusionPrototypeStore";
        @NotNull
        public static final String FUSION_MODEL_PATH_INDEX = "fusionPathIndex";
        @NotNull
        public static final String FUSION_MODEL_PARSER = "fusionParser";
        @NotNull
        public static final String FUSION_MODEL_AFX = "fusionAfx";

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteNames$Companion;", "", "()V", "FUSION_MODEL", "", "FUSION_MODEL_AFX", "FUSION_MODEL_PARSER", "FUSION_MODEL_PATH_INDEX", "FUSION_MODEL_PROTOTYPE_STORE", "OVERVIEW", "STYLEGUIDE", "packageNameToRouteName", "packageName", "packageNameToRouteName$styleguide", "styleguide"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            public static final String OVERVIEW = "overview";
            @NotNull
            public static final String STYLEGUIDE = "styleguide";
            @NotNull
            public static final String FUSION_MODEL = "fusion";
            @NotNull
            public static final String FUSION_MODEL_PROTOTYPE_STORE = "fusionPrototypeStore";
            @NotNull
            public static final String FUSION_MODEL_PATH_INDEX = "fusionPathIndex";
            @NotNull
            public static final String FUSION_MODEL_PARSER = "fusionParser";
            @NotNull
            public static final String FUSION_MODEL_AFX = "fusionAfx";

            private Companion() {
            }

            @NotNull
            public final String packageNameToRouteName$styleguide(@NotNull String packageName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                String string = packageName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                return "styleguide_" + StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u00a8\u0006\u0003"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteUrls;", "", "Companion", "styleguide"})
    public static interface RouteUrls {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String OVERVIEW = "/overview";
        @NotNull
        public static final String STYLEGUIDE = "/styleguide";
        @NotNull
        public static final String FUSION_MODEL = "/fusion";
        @NotNull
        public static final String FUSION_MODEL_PROTOTYPE_STORE = "/fusion/prototype-store";
        @NotNull
        public static final String FUSION_MODEL_PATH_INDEX = "/fusion/path-index";
        @NotNull
        public static final String FUSION_MODEL_PARSER = "/fusion/parser";
        @NotNull
        public static final String FUSION_MODEL_AFX = "/fusion/afx";

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteUrls$Companion;", "", "()V", "FUSION_MODEL", "", "FUSION_MODEL_AFX", "FUSION_MODEL_PARSER", "FUSION_MODEL_PATH_INDEX", "FUSION_MODEL_PROTOTYPE_STORE", "OVERVIEW", "STYLEGUIDE", "packageNameToUrlSlug", "value", "styleguidePackageUrl", "packageName", "styleguidePackageUrl$styleguide", "styleguide"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            public static final String OVERVIEW = "/overview";
            @NotNull
            public static final String STYLEGUIDE = "/styleguide";
            @NotNull
            public static final String FUSION_MODEL = "/fusion";
            @NotNull
            public static final String FUSION_MODEL_PROTOTYPE_STORE = "/fusion/prototype-store";
            @NotNull
            public static final String FUSION_MODEL_PATH_INDEX = "/fusion/path-index";
            @NotNull
            public static final String FUSION_MODEL_PARSER = "/fusion/parser";
            @NotNull
            public static final String FUSION_MODEL_AFX = "/fusion/afx";

            private Companion() {
            }

            @NotNull
            public final String styleguidePackageUrl$styleguide(@NotNull String packageName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                return "/styleguide/" + this.packageNameToUrlSlug(packageName);
            }

            @NotNull
            public final String packageNameToUrlSlug(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = StringsKt.replace$default((String)value, (String)".", (String)"-", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                return string;
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u00a8\u0006\u0003"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Routes;", "", "Companion", "styleguide"})
    public static interface Routes {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012J\u0014\u0010\u0015\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Routes$Companion;", "", "()V", "FUSION_MODEL", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteDefinition;", "getFUSION_MODEL", "()Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteDefinition;", "FUSION_MODEL_AFX", "getFUSION_MODEL_AFX", "FUSION_MODEL_PARSER", "getFUSION_MODEL_PARSER", "FUSION_MODEL_PATH_INDEX", "getFUSION_MODEL_PATH_INDEX", "FUSION_MODEL_PROTOTYPE_STORE", "getFUSION_MODEL_PROTOTYPE_STORE", "OVERVIEW", "getOVERVIEW", "createRoutes", "", "componentPackages", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "createStyleguideRoute", "styleguide"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final RouteDefinition OVERVIEW;
            @NotNull
            private static final RouteDefinition FUSION_MODEL_PROTOTYPE_STORE;
            @NotNull
            private static final RouteDefinition FUSION_MODEL_PATH_INDEX;
            @NotNull
            private static final RouteDefinition FUSION_MODEL_PARSER;
            @NotNull
            private static final RouteDefinition FUSION_MODEL_AFX;
            @NotNull
            private static final RouteDefinition FUSION_MODEL;

            private Companion() {
            }

            @NotNull
            public final RouteDefinition getOVERVIEW() {
                return OVERVIEW;
            }

            @NotNull
            public final RouteDefinition getFUSION_MODEL_PROTOTYPE_STORE() {
                return FUSION_MODEL_PROTOTYPE_STORE;
            }

            @NotNull
            public final RouteDefinition getFUSION_MODEL_PATH_INDEX() {
                return FUSION_MODEL_PATH_INDEX;
            }

            @NotNull
            public final RouteDefinition getFUSION_MODEL_PARSER() {
                return FUSION_MODEL_PARSER;
            }

            @NotNull
            public final RouteDefinition getFUSION_MODEL_AFX() {
                return FUSION_MODEL_AFX;
            }

            @NotNull
            public final RouteDefinition getFUSION_MODEL() {
                return FUSION_MODEL;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RouteDefinition createStyleguideRoute(@NotNull List<FusionPackageName> componentPackages) {
                Collection<RouteDefinition> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(componentPackages, (String)"componentPackages");
                Iterable iterable = componentPackages;
                String string = "/styleguide";
                String string2 = "Styleguide";
                String string3 = "styleguide";
                io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion companion = StyleguideRouter.Companion;
                boolean $i$f$map = false;
                void var4_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void componentPackage;
                    FusionPackageName fusionPackageName = (FusionPackageName)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String packageRouteName = RouteNames.Companion.packageNameToRouteName$styleguide(componentPackage.getName());
                    collection.add(io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, packageRouteName, "styleguide", componentPackage.getName(), RouteUrls.Companion.styleguidePackageUrl$styleguide(componentPackage.getName()), null, 8, null));
                }
                collection = (List)destination$iv$iv;
                return companion.routeDefinition(string3, string2, string, (List<RouteDefinition>)collection);
            }

            @NotNull
            public final List<RouteDefinition> createRoutes(@NotNull List<FusionPackageName> componentPackages) {
                Intrinsics.checkNotNullParameter(componentPackages, (String)"componentPackages");
                Object[] objectArray = new RouteDefinition[]{OVERVIEW, this.createStyleguideRoute(componentPackages), FUSION_MODEL};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            static {
                $$INSTANCE = new Companion();
                OVERVIEW = io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, "overview", "Overview", "/overview", null, 4, null);
                FUSION_MODEL_PROTOTYPE_STORE = io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, "fusionPrototypeStore", "Prototype Store", "/fusion/prototype-store", null, 4, null);
                FUSION_MODEL_PATH_INDEX = io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, "fusionPathIndex", "Path Index", "/fusion/path-index", null, 4, null);
                FUSION_MODEL_PARSER = io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, "fusionParser", "Parser", "/fusion/parser", null, 4, null);
                FUSION_MODEL_AFX = io.neos.fusion4j.styleguide.ui.StyleguideRouter$Companion.routeDefinition$default(StyleguideRouter.Companion, "fusionAfx", "AFX", "/fusion/afx", null, 4, null);
                Object[] objectArray = new RouteDefinition[]{FUSION_MODEL_PROTOTYPE_STORE, FUSION_MODEL_PATH_INDEX, FUSION_MODEL_PARSER, FUSION_MODEL_AFX};
                FUSION_MODEL = StyleguideRouter.Companion.routeDefinition("fusion", "Fusion Model", "/fusion", CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ*\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bJ4\u0010\n\u001a\u00020\t*\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u0010"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Companion;", "", "()V", "fromHttpServletRequest", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter;", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "routeDefinitions", "", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteDefinition;", "routeDefinition", "", "title", "url", "subRoutes", "parentRouteName", "styleguide"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StyleguideRouter fromHttpServletRequest(@NotNull HttpServletRequest httpRequest, @NotNull List<RouteDefinition> routeDefinitions) {
            void $this$mapTo$iv$iv;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void it;
            Map map;
            void $this$associateByTo$iv$iv2;
            void $this$associateBy$iv2;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
            Intrinsics.checkNotNullParameter(routeDefinitions, (String)"routeDefinitions");
            StyleguideRouterKt.access$getLog$p().debug((Function0)new Function0<Object>(httpRequest, routeDefinitions){
                final /* synthetic */ HttpServletRequest $httpRequest;
                final /* synthetic */ List<RouteDefinition> $routeDefinitions;
                {
                    this.$httpRequest = $httpRequest;
                    this.$routeDefinitions = $routeDefinitions;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Creating router for request " + this.$httpRequest + "; routes: " + this.$routeDefinitions;
                }
            });
            String currentUrl = httpRequest.getRequestURI();
            Iterable iterable = routeDefinitions;
            boolean $i$f$map22 = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                RouteDefinition routeDefinition = (RouteDefinition)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = it2.getRouteName();
                Intrinsics.checkNotNullExpressionValue((Object)currentUrl, (String)"currentUrl");
                object.add(TuplesKt.to((Object)string, (Object)it2.initializeRoute(currentUrl)));
            }
            List list = (List)destination$iv$iv;
            FusionDataStructure routes = new FusionDataStructure(list);
            Iterable $i$f$map22 = routes.getData();
            boolean $i$f$flatMap22 = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo22 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Pair it3 = (Pair)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = CollectionsKt.plus((Collection)((Route)it3.getSecond()).getSubRoutes().values(), (Object)it3.getSecond());
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List allRoutesFlat = (List)destination$iv$iv2;
            Iterable $i$f$flatMap22 = allRoutesFlat;
            boolean $i$f$associateBy = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
            void $i$f$flatMapTo22 = $this$associateBy$iv2;
            Object destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                Route route = (Route)element$iv$iv;
                map = destination$iv$iv3;
                boolean bl = false;
                map.put(it.getUrl(), element$iv$iv);
            }
            Object routesByUrl = destination$iv$iv3;
            if (routesByUrl.size() != allRoutesFlat.size()) {
                void $this$mapTo$iv$iv3;
                Iterable $this$map$iv2 = allRoutesFlat;
                boolean $i$f$map = false;
                Iterable capacity$iv2 = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it4;
                    Route element$iv$iv = (Route)item$iv$iv;
                    object = destination$iv$iv4;
                    boolean bl = false;
                    object.add(it4.getUrl());
                }
                String string = "Non unique route URLs: " + (List)destination$iv$iv4;
                throw new IllegalStateException(string);
            }
            Iterable $i$f$map = allRoutesFlat;
            boolean $i$f$associateBy2 = false;
            int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void $i$f$mapTo2 = $this$associateBy$iv;
            Map destination$iv$iv5 = new LinkedHashMap(capacity$iv32);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it5;
                Route bl = (Route)element$iv$iv;
                map = destination$iv$iv5;
                boolean bl2 = false;
                map.put(it5.getName(), element$iv$iv);
            }
            Map routesByName = destination$iv$iv5;
            if (routesByName.size() != allRoutesFlat.size()) {
                void $this$mapTo$iv$iv4;
                Iterable $this$map$iv3 = allRoutesFlat;
                boolean $i$f$map3 = false;
                Iterable capacity$iv32 = $this$map$iv3;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                    Object element$iv$iv;
                    element$iv$iv = (Route)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl = false;
                    object.add(it.getName());
                }
                String string = "Non unique route names: " + (List)destination$iv$iv3;
                throw new IllegalStateException(string);
            }
            Route route = (Route)routesByUrl.get(currentUrl);
            if (route == null) {
                Companion $this$fromHttpServletRequest_u24lambda_u2d6 = this;
                boolean bl = false;
                StyleguideRouterKt.access$getLog$p().warn((Function0)new Function0<Object>(currentUrl){
                    final /* synthetic */ String $currentUrl;
                    {
                        this.$currentUrl = $currentUrl;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "No styleguide route found for request " + this.$currentUrl;
                    }
                });
                route = null;
            }
            Route currentRoute2 = route;
            Iterable $this$map$iv4 = routeDefinitions;
            boolean $i$f$map4 = false;
            Iterable bl = $this$map$iv4;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it6;
                RouteDefinition bl2 = (RouteDefinition)item$iv$iv;
                object = destination$iv$iv6;
                boolean bl3 = false;
                object.add(TuplesKt.to((Object)it6.getRouteName(), (Object)it6));
            }
            List list2 = (List)destination$iv$iv6;
            FusionDataStructure routesData = new FusionDataStructure(list2);
            return new StyleguideRouter((FusionDataStructure<Route>)routes, currentRoute2, (FusionDataStructure<RouteDefinition>)routesData, httpRequest, (Map<String, Route>)routesByUrl, routesByName);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RouteDefinition routeDefinition(@NotNull String $this$routeDefinition, @Nullable String parentRouteName, @NotNull String title, @NotNull String url, @NotNull List<RouteDefinition> subRoutes) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$routeDefinition, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRoutes, (String)"subRoutes");
            Iterable iterable = subRoutes;
            String string = url;
            String string2 = title;
            String string3 = parentRouteName;
            String string4 = $this$routeDefinition;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RouteDefinition routeDefinition = (RouteDefinition)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it.getRouteName(), (Object)it));
            }
            Collection<Pair> collection2 = collection = (List)destination$iv$iv;
            FusionDataStructure fusionDataStructure = new FusionDataStructure((List)collection2);
            String string5 = string;
            String string6 = string2;
            String string7 = string3;
            String string8 = string4;
            return new RouteDefinition(string8, string7, string6, string5, (FusionDataStructure<RouteDefinition>)fusionDataStructure);
        }

        public static /* synthetic */ RouteDefinition routeDefinition$default(Companion companion, String string, String string2, String string3, String string4, List list, int n, Object object) {
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.routeDefinition(string, string2, string3, string4, list);
        }

        @NotNull
        public final RouteDefinition routeDefinition(@NotNull String $this$routeDefinition, @NotNull String title, @NotNull String url, @NotNull List<RouteDefinition> subRoutes) {
            Intrinsics.checkNotNullParameter((Object)$this$routeDefinition, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRoutes, (String)"subRoutes");
            return this.routeDefinition($this$routeDefinition, null, title, url, subRoutes);
        }

        public static /* synthetic */ RouteDefinition routeDefinition$default(Companion companion, String string, String string2, String string3, List list, int n, Object object) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.routeDefinition(string, string2, string3, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u00c6\u0003JC\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006!"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$RouteDefinition;", "", "routeName", "", "parentRouteName", "title", "url", "subRouteDefinitions", "Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/neos/fusion4j/runtime/model/FusionDataStructure;)V", "getParentRouteName", "()Ljava/lang/String;", "getRouteName", "getSubRouteDefinitions", "()Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "getTitle", "getUrl", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "initializeRoute", "Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Route;", "currentUrl", "isRouteOrSubRouteActive", "toString", "styleguide"})
    public static final class RouteDefinition {
        @NotNull
        private final String routeName;
        @Nullable
        private final String parentRouteName;
        @NotNull
        private final String title;
        @NotNull
        private final String url;
        @NotNull
        private final FusionDataStructure<RouteDefinition> subRouteDefinitions;

        public RouteDefinition(@NotNull String routeName, @Nullable String parentRouteName, @NotNull String title, @NotNull String url, @NotNull FusionDataStructure<RouteDefinition> subRouteDefinitions) {
            Intrinsics.checkNotNullParameter((Object)routeName, (String)"routeName");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRouteDefinitions, (String)"subRouteDefinitions");
            this.routeName = routeName;
            this.parentRouteName = parentRouteName;
            this.title = title;
            this.url = url;
            this.subRouteDefinitions = subRouteDefinitions;
        }

        @NotNull
        public final String getRouteName() {
            return this.routeName;
        }

        @Nullable
        public final String getParentRouteName() {
            return this.parentRouteName;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final FusionDataStructure<RouteDefinition> getSubRouteDefinitions() {
            return this.subRouteDefinitions;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Route initializeRoute(@NotNull String currentUrl) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)currentUrl, (String)"currentUrl");
            Iterable iterable = this.subRouteDefinitions.getData();
            boolean bl = this.isRouteOrSubRouteActive(currentUrl);
            String string = this.url;
            String string2 = this.title;
            String string3 = this.parentRouteName;
            String string4 = this.routeName;
            boolean $i$f$map = false;
            void var4_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it.getFirst(), (Object)((RouteDefinition)it.getSecond()).initializeRoute(currentUrl)));
            }
            Collection<Pair> collection2 = collection = (List)destination$iv$iv;
            FusionDataStructure fusionDataStructure = new FusionDataStructure((List)collection2);
            boolean bl3 = bl;
            String string5 = string;
            String string6 = string2;
            String string7 = string3;
            String string8 = string4;
            return new Route(string8, string7, string6, string5, bl3, (FusionDataStructure<Route>)fusionDataStructure);
        }

        private final boolean isRouteOrSubRouteActive(String currentUrl) {
            boolean bl;
            block4: {
                if (Intrinsics.areEqual((Object)this.url, (Object)currentUrl)) {
                    return true;
                }
                Iterable $this$any$iv = this.subRouteDefinitions.getValueList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RouteDefinition it = (RouteDefinition)element$iv;
                        boolean bl2 = false;
                        if (!it.isRouteOrSubRouteActive(currentUrl)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final String component1() {
            return this.routeName;
        }

        @Nullable
        public final String component2() {
            return this.parentRouteName;
        }

        @NotNull
        public final String component3() {
            return this.title;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @NotNull
        public final FusionDataStructure<RouteDefinition> component5() {
            return this.subRouteDefinitions;
        }

        @NotNull
        public final RouteDefinition copy(@NotNull String routeName, @Nullable String parentRouteName, @NotNull String title, @NotNull String url, @NotNull FusionDataStructure<RouteDefinition> subRouteDefinitions) {
            Intrinsics.checkNotNullParameter((Object)routeName, (String)"routeName");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRouteDefinitions, (String)"subRouteDefinitions");
            return new RouteDefinition(routeName, parentRouteName, title, url, subRouteDefinitions);
        }

        public static /* synthetic */ RouteDefinition copy$default(RouteDefinition routeDefinition, String string, String string2, String string3, String string4, FusionDataStructure fusionDataStructure, int n, Object object) {
            if ((n & 1) != 0) {
                string = routeDefinition.routeName;
            }
            if ((n & 2) != 0) {
                string2 = routeDefinition.parentRouteName;
            }
            if ((n & 4) != 0) {
                string3 = routeDefinition.title;
            }
            if ((n & 8) != 0) {
                string4 = routeDefinition.url;
            }
            if ((n & 0x10) != 0) {
                fusionDataStructure = routeDefinition.subRouteDefinitions;
            }
            return routeDefinition.copy(string, string2, string3, string4, fusionDataStructure);
        }

        @NotNull
        public String toString() {
            return "RouteDefinition(routeName=" + this.routeName + ", parentRouteName=" + this.parentRouteName + ", title=" + this.title + ", url=" + this.url + ", subRouteDefinitions=" + this.subRouteDefinitions + ")";
        }

        public int hashCode() {
            int result = this.routeName.hashCode();
            result = result * 31 + (this.parentRouteName == null ? 0 : this.parentRouteName.hashCode());
            result = result * 31 + this.title.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.subRouteDefinitions.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RouteDefinition)) {
                return false;
            }
            RouteDefinition routeDefinition = (RouteDefinition)other;
            if (!Intrinsics.areEqual((Object)this.routeName, (Object)routeDefinition.routeName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentRouteName, (Object)routeDefinition.parentRouteName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)routeDefinition.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)routeDefinition.url)) {
                return false;
            }
            return Intrinsics.areEqual(this.subRouteDefinitions, routeDefinition.subRouteDefinitions);
        }
    }

    @FusionApi
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0003JM\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0001J\u0013\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010%\u001a\u00020\bH\u0007J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\r\u001a\u0004\b\u0019\u0010\u0012R\u001c\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\r\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006)"}, d2={"Lio/neos/fusion4j/styleguide/ui/StyleguideRouter$Route;", "", "name", "", "parentRouteName", "title", "url", "active", "", "subRoutes", "Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLio/neos/fusion4j/runtime/model/FusionDataStructure;)V", "getActive$annotations", "()V", "getActive", "()Z", "getName$annotations", "getName", "()Ljava/lang/String;", "getParentRouteName$annotations", "getParentRouteName", "getSubRoutes$annotations", "getSubRoutes", "()Lio/neos/fusion4j/runtime/model/FusionDataStructure;", "getTitle$annotations", "getTitle", "getUrl$annotations", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "getIsGroup", "hashCode", "", "toString", "styleguide"})
    public static final class Route {
        @NotNull
        private final String name;
        @Nullable
        private final String parentRouteName;
        @NotNull
        private final String title;
        @NotNull
        private final String url;
        private final boolean active;
        @NotNull
        private final FusionDataStructure<Route> subRoutes;

        public Route(@NotNull String name, @Nullable String parentRouteName, @NotNull String title, @NotNull String url, boolean active, @NotNull FusionDataStructure<Route> subRoutes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRoutes, (String)"subRoutes");
            this.name = name;
            this.parentRouteName = parentRouteName;
            this.title = title;
            this.url = url;
            this.active = active;
            this.subRoutes = subRoutes;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @FusionApi
        public static /* synthetic */ void getName$annotations() {
        }

        @Nullable
        public final String getParentRouteName() {
            return this.parentRouteName;
        }

        @FusionApi
        public static /* synthetic */ void getParentRouteName$annotations() {
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @FusionApi
        public static /* synthetic */ void getTitle$annotations() {
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @FusionApi
        public static /* synthetic */ void getUrl$annotations() {
        }

        public final boolean getActive() {
            return this.active;
        }

        @FusionApi
        public static /* synthetic */ void getActive$annotations() {
        }

        @NotNull
        public final FusionDataStructure<Route> getSubRoutes() {
            return this.subRoutes;
        }

        @FusionApi
        public static /* synthetic */ void getSubRoutes$annotations() {
        }

        @FusionApi
        public final boolean getIsGroup() {
            return this.subRoutes.isNotEmpty();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.parentRouteName;
        }

        @NotNull
        public final String component3() {
            return this.title;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        public final boolean component5() {
            return this.active;
        }

        @NotNull
        public final FusionDataStructure<Route> component6() {
            return this.subRoutes;
        }

        @NotNull
        public final Route copy(@NotNull String name, @Nullable String parentRouteName, @NotNull String title, @NotNull String url, boolean active, @NotNull FusionDataStructure<Route> subRoutes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(subRoutes, (String)"subRoutes");
            return new Route(name, parentRouteName, title, url, active, subRoutes);
        }

        public static /* synthetic */ Route copy$default(Route route, String string, String string2, String string3, String string4, boolean bl, FusionDataStructure fusionDataStructure, int n, Object object) {
            if ((n & 1) != 0) {
                string = route.name;
            }
            if ((n & 2) != 0) {
                string2 = route.parentRouteName;
            }
            if ((n & 4) != 0) {
                string3 = route.title;
            }
            if ((n & 8) != 0) {
                string4 = route.url;
            }
            if ((n & 0x10) != 0) {
                bl = route.active;
            }
            if ((n & 0x20) != 0) {
                fusionDataStructure = route.subRoutes;
            }
            return route.copy(string, string2, string3, string4, bl, fusionDataStructure);
        }

        @NotNull
        public String toString() {
            return "Route(name=" + this.name + ", parentRouteName=" + this.parentRouteName + ", title=" + this.title + ", url=" + this.url + ", active=" + this.active + ", subRoutes=" + this.subRoutes + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.parentRouteName == null ? 0 : this.parentRouteName.hashCode());
            result = result * 31 + this.title.hashCode();
            result = result * 31 + this.url.hashCode();
            int n = this.active ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.subRoutes.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Route)) {
                return false;
            }
            Route route = (Route)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)route.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentRouteName, (Object)route.parentRouteName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)route.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)route.url)) {
                return false;
            }
            if (this.active != route.active) {
                return false;
            }
            return Intrinsics.areEqual(this.subRoutes, route.subRoutes);
        }
    }
}

