/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.spring.dev;

import io.neos.fusion4j.runtime.FusionObjectImplementationFactory;
import io.neos.fusion4j.runtime.eel.EelHelperFactory;
import io.neos.fusion4j.spring.FusionRuntimeContainer;
import io.neos.fusion4j.spring.FusionRuntimeFactory;
import io.neos.fusion4j.spring.RuntimeProperties;
import io.neos.fusion4j.spring.dev.LocalDevProperties;
import io.neos.fusion4j.spring.dev.LocalFusionFileWatcher;
import io.neos.fusion4j.spring.dev.LocalFusionFileWatcherConfiguration;
import io.neos.fusion4j.spring.dev.LocalFusionFileWatcherConfigurationKt;
import io.neos.fusion4j.spring.dev.ReloadingFusionRuntimeContainer;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ClassUtils;

@EnableConfigurationProperties(value={LocalDevProperties.class})
@Configuration
@ConditionalOnProperty(value={"io.neos.fusion4j.local-dev.enabled"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u0014"}, d2={"Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcherConfiguration;", "", "()V", "fusionFileWatcher", "Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcher;", "localDevProperties", "Lio/neos/fusion4j/spring/dev/LocalDevProperties;", "fusionRuntimeContainer", "Lio/neos/fusion4j/spring/FusionRuntimeContainer;", "logLocalDevWarning", "", "reloadingFusionRuntimeContainer", "runtimeProperties", "Lio/neos/fusion4j/spring/RuntimeProperties;", "runtimeFactory", "Lio/neos/fusion4j/spring/FusionRuntimeFactory;", "eelHelperFactory", "Lio/neos/fusion4j/runtime/eel/EelHelperFactory;", "fusionObjectImplementationFactory", "Lio/neos/fusion4j/runtime/FusionObjectImplementationFactory;", "styleguide"})
public class LocalFusionFileWatcherConfiguration {
    @PostConstruct
    public void logLocalDevWarning() {
        LocalFusionFileWatcherConfigurationKt.access$getLog$p().warn((Function0)logLocalDevWarning.1.INSTANCE);
        LocalFusionFileWatcherConfigurationKt.access$getLog$p().warn((Function0)logLocalDevWarning.2.INSTANCE);
        LocalFusionFileWatcherConfigurationKt.access$getLog$p().warn((Function0)logLocalDevWarning.3.INSTANCE);
    }

    @Bean
    @NotNull
    public LocalFusionFileWatcher fusionFileWatcher(@NotNull LocalDevProperties localDevProperties, @NotNull FusionRuntimeContainer fusionRuntimeContainer) {
        Intrinsics.checkNotNullParameter((Object)localDevProperties, (String)"localDevProperties");
        Intrinsics.checkNotNullParameter((Object)fusionRuntimeContainer, (String)"fusionRuntimeContainer");
        if (!(fusionRuntimeContainer instanceof ReloadingFusionRuntimeContainer)) {
            throw new IllegalStateException("Could not create Fusion file watcher; local dev mode only supports container class: " + ReloadingFusionRuntimeContainer.class.getName());
        }
        LocalFusionFileWatcher watcher = LocalFusionFileWatcher.Companion.initialize(localDevProperties, (ReloadingFusionRuntimeContainer)fusionRuntimeContainer);
        watcher.startFusionFileWatcher$styleguide();
        return watcher;
    }

    @Bean
    @Primary
    @NotNull
    public FusionRuntimeContainer reloadingFusionRuntimeContainer(@NotNull RuntimeProperties runtimeProperties, @NotNull FusionRuntimeFactory runtimeFactory, @NotNull EelHelperFactory eelHelperFactory2, @NotNull FusionObjectImplementationFactory fusionObjectImplementationFactory2) {
        Intrinsics.checkNotNullParameter((Object)runtimeProperties, (String)"runtimeProperties");
        Intrinsics.checkNotNullParameter((Object)runtimeFactory, (String)"runtimeFactory");
        Intrinsics.checkNotNullParameter((Object)eelHelperFactory2, (String)"eelHelperFactory");
        Intrinsics.checkNotNullParameter((Object)fusionObjectImplementationFactory2, (String)"fusionObjectImplementationFactory");
        LocalFusionFileWatcherConfigurationKt.access$getLog$p().info((Function0)reloadingFusionRuntimeContainer.1.INSTANCE);
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        return new ReloadingFusionRuntimeContainer(classLoader, runtimeProperties, runtimeFactory, eelHelperFactory2, fusionObjectImplementationFactory2);
    }
}

