/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.spring.dev;

import io.neos.fusion4j.lang.file.FilesystemFusionFile;
import io.neos.fusion4j.spring.dev.LocalDevProperties;
import io.neos.fusion4j.spring.dev.LocalFusionFileWatcher;
import io.neos.fusion4j.spring.dev.LocalFusionFileWatcherKt;
import io.neos.fusion4j.spring.dev.ReloadingFusionRuntimeContainer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\r\u0010\u000f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u000bH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcher;", "Lorg/springframework/boot/devtools/filewatch/FileChangeListener;", "watcher", "Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;", "watchDirectories", "", "Ljava/io/File;", "reloadingRuntime", "Lio/neos/fusion4j/spring/dev/ReloadingFusionRuntimeContainer;", "(Lorg/springframework/boot/devtools/filewatch/FileSystemWatcher;Ljava/util/Set;Lio/neos/fusion4j/spring/dev/ReloadingFusionRuntimeContainer;)V", "onChange", "", "changeSet", "", "Lorg/springframework/boot/devtools/filewatch/ChangedFiles;", "startFusionFileWatcher", "startFusionFileWatcher$styleguide", "stopFusionFileWatcher", "ChangedFusionPackage", "Companion", "styleguide"})
public final class LocalFusionFileWatcher
implements FileChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemWatcher watcher;
    @NotNull
    private final Set<File> watchDirectories;
    @NotNull
    private final ReloadingFusionRuntimeContainer reloadingRuntime;

    public LocalFusionFileWatcher(@NotNull FileSystemWatcher watcher, @NotNull Set<? extends File> watchDirectories, @NotNull ReloadingFusionRuntimeContainer reloadingRuntime) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter(watchDirectories, (String)"watchDirectories");
        Intrinsics.checkNotNullParameter((Object)reloadingRuntime, (String)"reloadingRuntime");
        this.watcher = watcher;
        this.watchDirectories = watchDirectories;
        this.reloadingRuntime = reloadingRuntime;
    }

    /*
     * WARNING - void declaration
     */
    public void onChange(@NotNull Set<ChangedFiles> changeSet) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(changeSet, (String)"changeSet");
        LocalFusionFileWatcherKt.access$getLog$p().debug((Function0)new Function0<Object>(changeSet){
            final /* synthetic */ Set<ChangedFiles> $changeSet;
            {
                this.$changeSet = $changeSet;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Fusion file change triggered: " + this.$changeSet;
            }
        });
        Iterable $this$filter$iv = changeSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChangedFiles it = (ChangedFiles)element$iv$iv;
            boolean bl = false;
            Set set = it.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.files");
            boolean bl2 = !((Collection)set).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChangedFusionPackage changedFusionPackage;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChangedFiles files = (ChangedFiles)element$iv$iv;
            boolean bl3 = false;
            Set set = files.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files.files");
            Iterable iterable2 = set;
            boolean $i$f$filter2 = false;
            void var18_21 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                ChangedFile it = (ChangedFile)element$iv$iv2;
                boolean bl4 = false;
                File file = it.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.file");
                if (!FilesystemFusionFile.Companion.isFusionFile(file)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Set fusionFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            if (!((Collection)fusionFiles).isEmpty()) {
                File file = files.getSourceDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"files.sourceDirectory");
                changedFusionPackage = new ChangedFusionPackage(file, fusionFiles);
            } else {
                changedFusionPackage = null;
            }
            if (changedFusionPackage == null) continue;
            ChangedFusionPackage it$iv$iv = changedFusionPackage;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set changedFusionPackages = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = changedFusionPackages;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangedFusionPackage changedPackage = (ChangedFusionPackage)element$iv;
            boolean bl = false;
            LocalFusionFileWatcherKt.access$getLog$p().info((Function0)new Function0<Object>(changedPackage){
                final /* synthetic */ ChangedFusionPackage $changedPackage;
                {
                    this.$changedPackage = $changedPackage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Fusion files changed for " + this.$changedPackage + " ";
                }
            });
        }
        if (!((Collection)changedFusionPackages).isEmpty()) {
            this.reloadingRuntime.reloadRuntime();
        }
    }

    public final void startFusionFileWatcher$styleguide() {
        if (!((Collection)this.watchDirectories).isEmpty()) {
            LocalFusionFileWatcherKt.access$getLog$p().info((Function0)new Function0<Object>(this){
                final /* synthetic */ LocalFusionFileWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Start watching Fusion file directories\n  - " + CollectionsKt.joinToString$default((Iterable)LocalFusionFileWatcher.access$getWatchDirectories$p(this.this$0), (CharSequence)"\n  - ", null, null, (int)0, null, (Function1)startFusionFileWatcher.1.INSTANCE, (int)30, null);
                }
            });
            this.watcher.start();
        } else {
            LocalFusionFileWatcherKt.access$getLog$p().info((Function0)startFusionFileWatcher.2.INSTANCE);
        }
    }

    @PreDestroy
    public final void stopFusionFileWatcher() {
        if (!((Collection)this.watchDirectories).isEmpty()) {
            LocalFusionFileWatcherKt.access$getLog$p().info((Function0)stopFusionFileWatcher.1.INSTANCE);
            this.watcher.stop();
        }
    }

    public static final /* synthetic */ Set access$getWatchDirectories$p(LocalFusionFileWatcher $this) {
        return $this.watchDirectories;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcher$ChangedFusionPackage;", "", "sourceDirectory", "Ljava/io/File;", "changedFiles", "", "Lorg/springframework/boot/devtools/filewatch/ChangedFile;", "(Ljava/io/File;Ljava/util/Set;)V", "getChangedFiles", "()Ljava/util/Set;", "getSourceDirectory", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "styleguide"})
    public static final class ChangedFusionPackage {
        @NotNull
        private final File sourceDirectory;
        @NotNull
        private final Set<ChangedFile> changedFiles;

        public ChangedFusionPackage(@NotNull File sourceDirectory, @NotNull Set<ChangedFile> changedFiles) {
            Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
            Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
            this.sourceDirectory = sourceDirectory;
            this.changedFiles = changedFiles;
        }

        @NotNull
        public final File getSourceDirectory() {
            return this.sourceDirectory;
        }

        @NotNull
        public final Set<ChangedFile> getChangedFiles() {
            return this.changedFiles;
        }

        @NotNull
        public String toString() {
            return "package path " + this.sourceDirectory + ":\n  - " + CollectionsKt.joinToString$default((Iterable)this.changedFiles, (CharSequence)"\n  - ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final File component1() {
            return this.sourceDirectory;
        }

        @NotNull
        public final Set<ChangedFile> component2() {
            return this.changedFiles;
        }

        @NotNull
        public final ChangedFusionPackage copy(@NotNull File sourceDirectory, @NotNull Set<ChangedFile> changedFiles) {
            Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
            Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
            return new ChangedFusionPackage(sourceDirectory, changedFiles);
        }

        public static /* synthetic */ ChangedFusionPackage copy$default(ChangedFusionPackage changedFusionPackage, File file, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                file = changedFusionPackage.sourceDirectory;
            }
            if ((n & 2) != 0) {
                set = changedFusionPackage.changedFiles;
            }
            return changedFusionPackage.copy(file, set);
        }

        public int hashCode() {
            int result = this.sourceDirectory.hashCode();
            result = result * 31 + ((Object)this.changedFiles).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangedFusionPackage)) {
                return false;
            }
            ChangedFusionPackage changedFusionPackage = (ChangedFusionPackage)other;
            if (!Intrinsics.areEqual((Object)this.sourceDirectory, (Object)changedFusionPackage.sourceDirectory)) {
                return false;
            }
            return Intrinsics.areEqual(this.changedFiles, changedFusionPackage.changedFiles);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcher$Companion;", "", "()V", "initialize", "Lio/neos/fusion4j/spring/dev/LocalFusionFileWatcher;", "localDevProperties", "Lio/neos/fusion4j/spring/dev/LocalDevProperties;", "fusionRuntimeContainer", "Lio/neos/fusion4j/spring/dev/ReloadingFusionRuntimeContainer;", "styleguide"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LocalFusionFileWatcher initialize(@NotNull LocalDevProperties localDevProperties, @NotNull ReloadingFusionRuntimeContainer fusionRuntimeContainer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)localDevProperties, (String)"localDevProperties");
            Intrinsics.checkNotNullParameter((Object)fusionRuntimeContainer, (String)"fusionRuntimeContainer");
            FileSystemWatcher watcher = new FileSystemWatcher(true, Duration.ofMillis(localDevProperties.getWatcherPollIntervalInMillisWithDefault()), Duration.ofMillis(localDevProperties.getWatcherQuietPeriodInMillisWithDefault()));
            Iterable iterable = localDevProperties.getFileSystemPackagesWithDefault().values();
            boolean $i$f$map = false;
            void var7_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path = Paths.get((String)it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
                collection.add(path.toFile());
            }
            Set watchDirectories = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            LocalFusionFileWatcher watcherService = new LocalFusionFileWatcher(watcher, watchDirectories, fusionRuntimeContainer);
            watcher.addListener((FileChangeListener)watcherService);
            watcher.addSourceDirectories((Iterable)watchDirectories);
            return watcherService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

