/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.spring;

import io.neos.fusion4j.lang.FusionError;
import io.neos.fusion4j.lang.model.AbsoluteFusionPathName;
import io.neos.fusion4j.lang.model.FusionPathName;
import io.neos.fusion4j.runtime.FusionContext;
import io.neos.fusion4j.runtime.FusionRuntime;
import io.neos.fusion4j.spring.FusionErrorHandlerKt;
import io.neos.fusion4j.spring.HttpResponseImplementation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/neos/fusion4j/spring/FusionErrorHandler;", "", "runtime", "Lio/neos/fusion4j/runtime/FusionRuntime;", "(Lio/neos/fusion4j/runtime/FusionRuntime;)V", "fallbackError", "", "errorMessage", "stacktrace", "request", "Ljavax/servlet/http/HttpServletRequest;", "criticalError", "", "handleFusionError", "Lio/neos/fusion4j/spring/HttpResponseImplementation$FusionHttpResponse;", "errorRenderPath", "error", "Lio/neos/fusion4j/lang/FusionError;", "httpRequest", "renderErrorResponseBody", "Lio/neos/fusion4j/lang/model/AbsoluteFusionPathName;", "unpackErrorMessages", "level", "", "styleguide"})
public final class FusionErrorHandler {
    @NotNull
    private final FusionRuntime runtime;

    public FusionErrorHandler(@NotNull FusionRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
    }

    @NotNull
    public final HttpResponseImplementation.FusionHttpResponse handleFusionError(@NotNull String errorRenderPath, @NotNull FusionError error, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)errorRenderPath, (String)"errorRenderPath");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        FusionErrorHandlerKt.access$getLog$p().error("Fusion runtime error: " + error, (Throwable)error);
        return this.renderErrorResponseBody(FusionPathName.Companion.parseAbsolute(errorRenderPath), FusionErrorHandler.unpackErrorMessages$default(this, (Throwable)error, 0, 2, null), ExceptionsKt.stackTraceToString((Throwable)((Throwable)error)), httpRequest);
    }

    private final String unpackErrorMessages(Throwable error, int level) {
        Throwable cause = error.getCause();
        return error.getMessage() + (String)(cause != null ? "\n " + StringsKt.repeat((CharSequence)" ", (int)level) + "- " + this.unpackErrorMessages(cause, level + 1) : "");
    }

    static /* synthetic */ String unpackErrorMessages$default(FusionErrorHandler fusionErrorHandler, Throwable throwable, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return fusionErrorHandler.unpackErrorMessages(throwable, n);
    }

    private final HttpResponseImplementation.FusionHttpResponse renderErrorResponseBody(AbsoluteFusionPathName errorRenderPath, String errorMessage, String stacktrace, HttpServletRequest httpRequest) {
        HttpResponseImplementation.FusionHttpResponse fusionHttpResponse;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"errorMessage", (Object)errorMessage), TuplesKt.to((Object)"stacktrace", (Object)stacktrace), TuplesKt.to((Object)"requestUri", (Object)httpRequest.getRequestURI())};
        FusionContext errorContext = FusionContext.Companion.create$default((FusionContext.Companion)FusionContext.Companion, (Map)MapsKt.mapOf((Pair[])pairArray), null, (int)2, null);
        Function1 fallbackErrorProvider2 = (Function1)new Function1<Throwable, HttpResponseImplementation.FusionHttpResponse>(this, errorMessage, stacktrace, httpRequest){
            final /* synthetic */ FusionErrorHandler this$0;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $stacktrace;
            final /* synthetic */ HttpServletRequest $httpRequest;
            {
                this.this$0 = $receiver;
                this.$errorMessage = $errorMessage;
                this.$stacktrace = $stacktrace;
                this.$httpRequest = $httpRequest;
                super(1);
            }

            @NotNull
            public final HttpResponseImplementation.FusionHttpResponse invoke(@Nullable Throwable error) {
                return new HttpResponseImplementation.FusionHttpResponse(500, CollectionsKt.listOf((Object)TuplesKt.to((Object)"content-type", (Object)"text/html")), FusionErrorHandler.access$fallbackError(this.this$0, this.$errorMessage, this.$stacktrace, this.$httpRequest, error));
            }
        };
        try {
            FusionRuntime $this$evaluateTyped$iv = this.runtime;
            boolean $i$f$evaluateTyped = false;
            HttpResponseImplementation.FusionHttpResponse fusionHttpResponse2 = (HttpResponseImplementation.FusionHttpResponse)$this$evaluateTyped$iv.evaluate(errorRenderPath, HttpResponseImplementation.FusionHttpResponse.class, errorContext);
            if (fusionHttpResponse2 == null) {
                fusionHttpResponse2 = (HttpResponseImplementation.FusionHttpResponse)fallbackErrorProvider2.invoke(null);
            }
            fusionHttpResponse = fusionHttpResponse2;
        }
        catch (Throwable error) {
            FusionErrorHandlerKt.access$getLog$p().error("Could not render Fusion error page:", error);
            fusionHttpResponse = (HttpResponseImplementation.FusionHttpResponse)fallbackErrorProvider2.invoke((Object)error);
        }
        return fusionHttpResponse;
    }

    private final String fallbackError(String errorMessage, String stacktrace, HttpServletRequest request, Throwable criticalError) {
        String string;
        if (criticalError != null) {
            String criticalErrorMessage = FusionErrorHandler.unpackErrorMessages$default(this, criticalError, 0, 2, null);
            String criticalStacktrace = ExceptionsKt.stackTraceToString((Throwable)criticalError);
            string = StringsKt.trimIndent((String)("\n                <h1>Error page could not be rendered</h1>\n                <div>\n                    <h2>Critical message:</h2>\n                    <pre>" + criticalErrorMessage + "</pre>\n                </div>\n                <div>\n                    <h2>Stacktrace:</h2>\n                    <pre>" + criticalStacktrace + "</pre>\n                </div>\n            "));
        } else {
            string = "";
        }
        String criticalPart = string;
        String requestUri = request.getRequestURI();
        return StringsKt.trimIndent((String)("\n            <html>\n                <head>\n                    <title>Critical Fusion Error</title>\n                </head>\n                <body>\n                    <div>\n                        <h1>Critical Fusion Error</h1>\n                        <p>URI: " + requestUri + "</p>\n                        <div>\n                            <h2>Message:</h2>\n                            <pre>" + errorMessage + "</pre>\n                        </div>\n                        <div>\n                            <h2>Stacktrace:</h2>\n                            <pre>" + stacktrace + "</pre>\n                        </div>\n                        " + criticalPart + "\n                    </div>\n                </body>\n            </html>\n        "));
    }

    static /* synthetic */ String fallbackError$default(FusionErrorHandler fusionErrorHandler, String string, String string2, HttpServletRequest httpServletRequest, Throwable throwable, int n, Object object) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        return fusionErrorHandler.fallbackError(string, string2, httpServletRequest, throwable);
    }

    public static final /* synthetic */ String access$fallbackError(FusionErrorHandler $this, String errorMessage, String stacktrace, HttpServletRequest request, Throwable criticalError) {
        return $this.fallbackError(errorMessage, stacktrace, request, criticalError);
    }
}

