/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.util;

import io.neos.fusion4j.lang.util.TimeMeasureUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ/\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/neos/fusion4j/lang/util/FusionProfiler;", "", "enabled", "", "profilers", "", "", "Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler;", "(ZLjava/util/Map;)V", "getEnabled", "()Z", "profile", "T", "profilerName", "description", "code", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "Profiler", "lang"})
public final class FusionProfiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private final Map<String, Profiler> profilers;
    @NotNull
    public static final String LOGGER_BASE_NAME = "fusion4j.Profiler";
    private static final long DEFAULT_DEBUG_THRESHOLD = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MICROSECONDS));
    private static final long DEFAULT_INFO_THRESHOLD = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MILLISECONDS));
    private static final long DEFAULT_WARN_THRESHOLD = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)50, (DurationUnit)DurationUnit.MILLISECONDS));
    @NotNull
    public static final String PROFILER_EVALUATE_EEL_EXPRESSION = "EVAL_EEL";
    @NotNull
    public static final String PROFILER_EVALUATE_FUSION_OBJECT = "EVAL_OBJ";
    @NotNull
    public static final String PROFILER_EVALUATE_PRIMITIVE = "EVAL_PRIM";
    @NotNull
    private static final Map<String, Profiler> DEFAULT_PROFILERS;

    public FusionProfiler(boolean enabled, @NotNull Map<String, Profiler> profilers) {
        Intrinsics.checkNotNullParameter(profilers, (String)"profilers");
        this.enabled = enabled;
        this.profilers = profilers;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final <T> T profile(@NotNull String profilerName, @NotNull String description, @NotNull Function0<? extends T> code) {
        Intrinsics.checkNotNullParameter((Object)profilerName, (String)"profilerName");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        if (!this.enabled) {
            return (T)code.invoke();
        }
        Profiler profiler = this.profilers.get(profilerName);
        if (profiler == null) {
            throw new IllegalArgumentException("Profiler " + profilerName + " no found");
        }
        Profiler profiler2 = profiler;
        TimeMeasureUtil.ResultAndDuration resultAndTime2 = TimeMeasureUtil.Companion.measureTime((Function0)new Function0<T>(code){
            final /* synthetic */ Function0<T> $code;
            {
                this.$code = $code;
                super(0);
            }

            public final T invoke() {
                return (T)this.$code.invoke();
            }
        });
        profiler2.log$lang(resultAndTime2, description);
        return (T)resultAndTime2.getResult();
    }

    static {
        Pair[] pairArray = new Pair[]{Profiler.Companion.defaultProfilerAndName(PROFILER_EVALUATE_EEL_EXPRESSION), Profiler.Companion.defaultProfilerAndName(PROFILER_EVALUATE_FUSION_OBJECT), Profiler.Companion.defaultProfilerAndName(PROFILER_EVALUATE_PRIMITIVE)};
        DEFAULT_PROFILERS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/neos/fusion4j/lang/util/FusionProfiler$Companion;", "", "()V", "DEFAULT_DEBUG_THRESHOLD", "", "getDEFAULT_DEBUG_THRESHOLD", "()J", "DEFAULT_INFO_THRESHOLD", "getDEFAULT_INFO_THRESHOLD", "DEFAULT_PROFILERS", "", "", "Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler;", "getDEFAULT_PROFILERS", "()Ljava/util/Map;", "DEFAULT_WARN_THRESHOLD", "getDEFAULT_WARN_THRESHOLD", "LOGGER_BASE_NAME", "PROFILER_EVALUATE_EEL_EXPRESSION", "PROFILER_EVALUATE_FUSION_OBJECT", "PROFILER_EVALUATE_PRIMITIVE", "disabled", "Lio/neos/fusion4j/lang/util/FusionProfiler;", "lang"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_DEBUG_THRESHOLD() {
            return DEFAULT_DEBUG_THRESHOLD;
        }

        public final long getDEFAULT_INFO_THRESHOLD() {
            return DEFAULT_INFO_THRESHOLD;
        }

        public final long getDEFAULT_WARN_THRESHOLD() {
            return DEFAULT_WARN_THRESHOLD;
        }

        @NotNull
        public final Map<String, Profiler> getDEFAULT_PROFILERS() {
            return DEFAULT_PROFILERS;
        }

        @NotNull
        public final FusionProfiler disabled() {
            return new FusionProfiler(false, MapsKt.emptyMap());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ!\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0010J)\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler;", "", "profilerName", "", "debugThresholdInNanos", "", "infoThresholdInNanos", "warnThresholdInNanos", "(Ljava/lang/String;JJJ)V", "logger", "Lmu/KLogger;", "log", "", "resultAndTime", "Lio/neos/fusion4j/lang/util/TimeMeasureUtil$ResultAndDuration;", "description", "log$lang", "merge", "newDebugThresholdInNanos", "newInfoThresholdInNanos", "newWarnThresholdInNanos", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;)Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler;", "Companion", "lang"})
    public static final class Profiler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String profilerName;
        private final long debugThresholdInNanos;
        private final long infoThresholdInNanos;
        private final long warnThresholdInNanos;
        @NotNull
        private final KLogger logger;

        public Profiler(@NotNull String profilerName, long debugThresholdInNanos, long infoThresholdInNanos, long warnThresholdInNanos) {
            Intrinsics.checkNotNullParameter((Object)profilerName, (String)"profilerName");
            this.profilerName = profilerName;
            this.debugThresholdInNanos = debugThresholdInNanos;
            this.infoThresholdInNanos = infoThresholdInNanos;
            this.warnThresholdInNanos = warnThresholdInNanos;
            this.logger = KotlinLogging.INSTANCE.logger("fusion4j.Profiler." + this.profilerName);
            if (this.warnThresholdInNanos < this.infoThresholdInNanos) {
                throw new IllegalArgumentException("Could not create profiler '" + this.profilerName + "'; warn threshold must be greater than info threshold, but was warn: " + this.warnThresholdInNanos + ", info: " + this.infoThresholdInNanos);
            }
            if (this.infoThresholdInNanos < this.debugThresholdInNanos) {
                throw new IllegalArgumentException("Could not create profiler '" + this.profilerName + "'; info threshold must be greater than debug threshold, but was warn: " + this.warnThresholdInNanos + ", info: " + this.infoThresholdInNanos);
            }
        }

        @NotNull
        public final Profiler merge(@Nullable Long newDebugThresholdInNanos, @Nullable Long newInfoThresholdInNanos, @Nullable Long newWarnThresholdInNanos) {
            Long l = newDebugThresholdInNanos;
            Long l2 = newInfoThresholdInNanos;
            Long l3 = newWarnThresholdInNanos;
            return new Profiler(this.profilerName, l != null ? l : this.debugThresholdInNanos, l2 != null ? l2 : this.infoThresholdInNanos, l3 != null ? l3 : this.warnThresholdInNanos);
        }

        public final void log$lang(@NotNull TimeMeasureUtil.ResultAndDuration<?> resultAndTime2, @NotNull String description) {
            Intrinsics.checkNotNullParameter(resultAndTime2, (String)"resultAndTime");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            long durationInNanos = Duration.getInWholeNanoseconds-impl((long)resultAndTime2.getDuration-UwyO8pc());
            Function0 message2 = (Function0)new Function0<String>(resultAndTime2, description){
                final /* synthetic */ TimeMeasureUtil.ResultAndDuration<?> $resultAndTime;
                final /* synthetic */ String $description;
                {
                    this.$resultAndTime = $resultAndTime;
                    this.$description = $description;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$resultAndTime.buildDurationMessage(this.$description);
                }
            };
            if (durationInNanos >= this.debugThresholdInNanos) {
                if (durationInNanos < this.infoThresholdInNanos) {
                    this.logger.debug(message2);
                } else if (durationInNanos < this.warnThresholdInNanos) {
                    this.logger.info(message2);
                } else {
                    this.logger.warn(message2);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler$Companion;", "", "()V", "defaultProfiler", "Lio/neos/fusion4j/lang/util/FusionProfiler$Profiler;", "profileName", "", "defaultProfilerAndName", "Lkotlin/Pair;", "lang"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Profiler defaultProfiler(@NotNull String profileName) {
                Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
                return new Profiler(profileName, FusionProfiler.Companion.getDEFAULT_DEBUG_THRESHOLD(), FusionProfiler.Companion.getDEFAULT_INFO_THRESHOLD(), FusionProfiler.Companion.getDEFAULT_WARN_THRESHOLD());
            }

            @NotNull
            public final Pair<String, Profiler> defaultProfilerAndName(@NotNull String profileName) {
                Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
                return TuplesKt.to((Object)profileName, (Object)this.defaultProfiler(profileName));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

