/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.semantic;

import io.neos.fusion4j.lang.model.FusionPathNameBuilder;
import io.neos.fusion4j.lang.model.FusionPathNameSegmentsBuilder;
import io.neos.fusion4j.lang.model.RelativeFusionPathName;
import io.neos.fusion4j.lang.semantic.AfterPosition;
import io.neos.fusion4j.lang.semantic.BeforePosition;
import io.neos.fusion4j.lang.semantic.EndPosition;
import io.neos.fusion4j.lang.semantic.KeyPositionParseException;
import io.neos.fusion4j.lang.semantic.MiddlePosition;
import io.neos.fusion4j.lang.semantic.StartPosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lio/neos/fusion4j/lang/semantic/KeyPosition;", "", "subject", "", "getSubject", "()Ljava/lang/String;", "Companion", "lang"})
public interface KeyPosition {
    @NotNull
    public static final Companion Companion = io.neos.fusion4j.lang.semantic.KeyPosition$Companion.$$INSTANCE;

    @NotNull
    public String getSubject();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/neos/fusion4j/lang/semantic/KeyPosition$Companion;", "", "()V", "AFTER_PATTERN", "Lkotlin/text/Regex;", "BEFORE_PATTERN", "END_PATTERN", "NUMERIC_PATTERN", "START_PATTERN", "isNumericKey", "", "relativePath", "Lio/neos/fusion4j/lang/model/RelativeFusionPathName;", "parseFromString", "Lio/neos/fusion4j/lang/semantic/KeyPosition;", "subjectRaw", "", "lang"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Regex NUMERIC_PATTERN;
        @NotNull
        private static final Regex BEFORE_PATTERN;
        @NotNull
        private static final Regex AFTER_PATTERN;
        @NotNull
        private static final Regex START_PATTERN;
        @NotNull
        private static final Regex END_PATTERN;

        private Companion() {
        }

        public final boolean isNumericKey(@NotNull RelativeFusionPathName relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            return NUMERIC_PATTERN.matches((CharSequence)relativePath.getPropertyName());
        }

        @NotNull
        public final KeyPosition parseFromString(@NotNull String subjectRaw) {
            Intrinsics.checkNotNullParameter((Object)subjectRaw, (String)"subjectRaw");
            String subject = ((Object)StringsKt.trim((CharSequence)subjectRaw)).toString();
            if (((CharSequence)subject).length() == 0) {
                throw new KeyPositionParseException(subject, "subject must not be blank", null, 4, null);
            }
            CharSequence charSequence = subject;
            if (NUMERIC_PATTERN.matches(charSequence)) {
                return new MiddlePosition(subject, Integer.parseInt(subject));
            }
            MatchResult beforeMatch = BEFORE_PATTERN.matchEntire((CharSequence)subject);
            if (beforeMatch != null) {
                int weight;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)beforeMatch.getGroups(), (String)"weight");
                int n = weight = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)beforeMatch.getGroups(), (String)"key");
                if (object2 == null || (object2 = object2.getValue()) == null) {
                    throw new KeyPositionParseException(subject, "could not parse before key", null, 4, null);
                }
                Object keyString = object2;
                return new BeforePosition(subject, weight, (RelativeFusionPathName)FusionPathNameSegmentsBuilder.property$default(FusionPathNameBuilder.Companion.relative(), (String)keyString, null, 2, null).build());
            }
            MatchResult afterMatch = AFTER_PATTERN.matchEntire((CharSequence)subject);
            if (afterMatch != null) {
                int weight;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)afterMatch.getGroups(), (String)"weight");
                int n = weight = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
                Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)afterMatch.getGroups(), (String)"key");
                if (object3 == null || (object3 = object3.getValue()) == null) {
                    throw new KeyPositionParseException(subject, "could not parse after key", null, 4, null);
                }
                Object keyString = object3;
                return new AfterPosition(subject, weight, (RelativeFusionPathName)FusionPathNameSegmentsBuilder.property$default(FusionPathNameBuilder.Companion.relative(), (String)keyString, null, 2, null).build());
            }
            MatchResult startMatch = START_PATTERN.matchEntire((CharSequence)subject);
            if (startMatch != null) {
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)startMatch.getGroups(), (String)"weight");
                int weight = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
                return new StartPosition(subject, weight);
            }
            MatchResult endMatch = END_PATTERN.matchEntire((CharSequence)subject);
            if (endMatch != null) {
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)endMatch.getGroups(), (String)"weight");
                int weight = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
                return new EndPosition(subject, weight);
            }
            throw new KeyPositionParseException(subject, "unknown subject", null, 4, null);
        }

        static {
            $$INSTANCE = new Companion();
            NUMERIC_PATTERN = new Regex("^\\d+$");
            BEFORE_PATTERN = new Regex("^before\\s+(?<key>[a-zA-Z0-9_\\-:]+)(\\s+(?<weight>\\d+))?$");
            AFTER_PATTERN = new Regex("^after\\s+(?<key>[a-zA-Z0-9_\\-:]+)(\\s+(?<weight>\\d+))?$");
            START_PATTERN = new Regex("^start(\\s+(?<weight>\\d+))?$");
            END_PATTERN = new Regex("^end(\\s+(?<weight>\\d+))?$");
        }
    }
}

