/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.semantic;

import io.neos.fusion4j.lang.model.AbsoluteFusionPathName;
import io.neos.fusion4j.lang.model.QualifiedPrototypeName;
import io.neos.fusion4j.lang.model.RelativeFusionPathName;
import io.neos.fusion4j.lang.model.decl.FusionLangElement;
import io.neos.fusion4j.lang.semantic.EvaluationPath;
import io.neos.fusion4j.lang.semantic.EvaluationPathSegment;
import io.neos.fusion4j.lang.semantic.FusionObjectInstance;
import io.neos.fusion4j.lang.semantic.FusionObjectInstanceLoaderKt;
import io.neos.fusion4j.lang.semantic.FusionPaths;
import io.neos.fusion4j.lang.semantic.FusionPrototype;
import io.neos.fusion4j.lang.semantic.FusionValueReference;
import io.neos.fusion4j.lang.semantic.SemanticallyNormalizedFusionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/neos/fusion4j/lang/semantic/FusionObjectInstanceLoader;", "", "semanticallyNormalizedFusionModel", "Lio/neos/fusion4j/lang/semantic/SemanticallyNormalizedFusionModel;", "(Lio/neos/fusion4j/lang/semantic/SemanticallyNormalizedFusionModel;)V", "instanceCache", "", "Lio/neos/fusion4j/lang/semantic/EvaluationPath;", "Lio/neos/fusion4j/lang/semantic/FusionObjectInstance;", "getAllEvaluationPathInstanceAttributes", "", "Lio/neos/fusion4j/lang/model/RelativeFusionPathName;", "Lio/neos/fusion4j/lang/semantic/FusionValueReference;", "evaluationPath", "loadInstance", "instanceDeclaration", "Lio/neos/fusion4j/lang/model/decl/FusionLangElement;", "Companion", "lang"})
public final class FusionObjectInstanceLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SemanticallyNormalizedFusionModel semanticallyNormalizedFusionModel;
    @NotNull
    private final Map<EvaluationPath, FusionObjectInstance> instanceCache;
    private static final boolean CACHE_ENABLED = true;

    public FusionObjectInstanceLoader(@NotNull SemanticallyNormalizedFusionModel semanticallyNormalizedFusionModel) {
        Intrinsics.checkNotNullParameter((Object)semanticallyNormalizedFusionModel, (String)"semanticallyNormalizedFusionModel");
        this.semanticallyNormalizedFusionModel = semanticallyNormalizedFusionModel;
        this.instanceCache = new LinkedHashMap();
    }

    @NotNull
    public final FusionObjectInstance loadInstance(@NotNull EvaluationPath evaluationPath, @NotNull FusionLangElement instanceDeclaration) {
        Intrinsics.checkNotNullParameter((Object)evaluationPath, (String)"evaluationPath");
        Intrinsics.checkNotNullParameter((Object)instanceDeclaration, (String)"instanceDeclaration");
        FusionObjectInstance cached = this.instanceCache.get(evaluationPath);
        if (cached != null) {
            return cached;
        }
        QualifiedPrototypeName prototypeName = evaluationPath.getCurrentPrototypeName();
        if (FusionObjectInstanceLoaderKt.access$getLog$p().isDebugEnabled()) {
            FusionObjectInstanceLoaderKt.access$getLog$p().debug("Loading Fusion Object instance for evaluation path '" + evaluationPath + "' and prototype " + prototypeName);
        }
        FusionPrototype prototype = this.semanticallyNormalizedFusionModel.getPrototypeStore().get(prototypeName);
        AbsoluteFusionPathName instancePath = evaluationPath.toDeclarationPath();
        Map<RelativeFusionPathName, FusionValueReference> instanceChildPaths = this.semanticallyNormalizedFusionModel.getRawIndex().resolveChildPathFusionValues(instancePath);
        Map<RelativeFusionPathName, FusionValueReference> evaluationPathInstanceAttributes = this.getAllEvaluationPathInstanceAttributes(evaluationPath);
        FusionObjectInstance fusionObjectInstance = new FusionObjectInstance(evaluationPath, instanceDeclaration, prototype, instanceChildPaths, evaluationPathInstanceAttributes, FusionPaths.Companion.getPOSITION_META_ATTRIBUTE());
        this.instanceCache.put(evaluationPath, fusionObjectInstance);
        return fusionObjectInstance;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<RelativeFusionPathName, FusionValueReference> getAllEvaluationPathInstanceAttributes(EvaluationPath evaluationPath) {
        void $this$foldIndexed$iv;
        Iterable iterable = evaluationPath.getSegments().subList(0, evaluationPath.getSegments().size() - 1);
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            Map map;
            void parentSegment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EvaluationPathSegment evaluationPathSegment = (EvaluationPathSegment)element$iv;
            Map map2 = accumulator$iv;
            int idx = n;
            boolean bl = false;
            if (parentSegment.getType() == null) {
                map = result;
            } else {
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                FusionPrototype parentPrototype = this.semanticallyNormalizedFusionModel.getPrototypeStore().get(parentSegment.getType());
                Iterable iterable2 = evaluationPath.getSegments().subList(idx + 1, evaluationPath.getSegments().size());
                boolean $i$f$map = false;
                void var17_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    EvaluationPathSegment evaluationPathSegment2 = (EvaluationPathSegment)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.getNestedPath());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv2 = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void path2;
                    RelativeFusionPathName $i$f$mapTo2 = (RelativeFusionPathName)iterator$iv.next();
                    RelativeFusionPathName path1 = (RelativeFusionPathName)accumulator$iv2;
                    boolean bl3 = false;
                    accumulator$iv2 = path1.plus((RelativeFusionPathName)path2);
                }
                RelativeFusionPathName nestedPath = (RelativeFusionPathName)accumulator$iv2;
                Map<RelativeFusionPathName, FusionValueReference> allPathsFromInheritanceChain = parentPrototype.getChildPaths(evaluationPath, nestedPath);
                map = MapsKt.plus((Map)result, allPathsFromInheritanceChain);
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/neos/fusion4j/lang/semantic/FusionObjectInstanceLoader$Companion;", "", "()V", "CACHE_ENABLED", "", "lang"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

