/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.semantic;

import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.model.FusionPackageName;
import io.neos.fusion4j.lang.model.decl.CodeIndexedElement;
import io.neos.fusion4j.lang.parser.RawFusionModel;
import io.neos.fusion4j.lang.semantic.CodeIndexedElementOrder;
import io.neos.fusion4j.lang.semantic.FileIncludeOrder;
import io.neos.fusion4j.lang.semantic.PackageLoadOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/neos/fusion4j/lang/semantic/FusionLoadOrder;", "", "rawFusionModel", "Lio/neos/fusion4j/lang/parser/RawFusionModel;", "packageLoadOrder", "", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "packageEntrypoints", "", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "(Lio/neos/fusion4j/lang/parser/RawFusionModel;Ljava/util/List;Ljava/util/Map;)V", "codeIndexedOrder", "Lio/neos/fusion4j/lang/semantic/CodeIndexedElementOrder;", "elementOrder", "Ljava/util/Comparator;", "Lio/neos/fusion4j/lang/model/decl/CodeIndexedElement;", "Lkotlin/Comparator;", "getElementOrder", "()Ljava/util/Comparator;", "includeOrder", "Lio/neos/fusion4j/lang/semantic/FileIncludeOrder;", "packageOrder", "Lio/neos/fusion4j/lang/semantic/PackageLoadOrder;", "toString", "", "lang"})
public final class FusionLoadOrder {
    @NotNull
    private final PackageLoadOrder packageOrder;
    @NotNull
    private final FileIncludeOrder includeOrder;
    @NotNull
    private final CodeIndexedElementOrder codeIndexedOrder;
    @NotNull
    private final Comparator<CodeIndexedElement> elementOrder;

    public FusionLoadOrder(@NotNull RawFusionModel rawFusionModel, @NotNull List<FusionPackageName> packageLoadOrder, @NotNull Map<FusionPackageName, FusionResourceName> packageEntrypoints) {
        Intrinsics.checkNotNullParameter((Object)rawFusionModel, (String)"rawFusionModel");
        Intrinsics.checkNotNullParameter(packageLoadOrder, (String)"packageLoadOrder");
        Intrinsics.checkNotNullParameter(packageEntrypoints, (String)"packageEntrypoints");
        this.packageOrder = new PackageLoadOrder(packageLoadOrder);
        this.includeOrder = FileIncludeOrder.Companion.create(rawFusionModel, packageEntrypoints);
        this.codeIndexedOrder = new CodeIndexedElementOrder();
        Comparator comparator = this.packageOrder.thenComparing(this.includeOrder).thenComparing(this.codeIndexedOrder);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"packageOrder\n        .th\u2026mparing(codeIndexedOrder)");
        this.elementOrder = comparator;
        if (packageLoadOrder.isEmpty()) {
            throw new IllegalArgumentException("load order must not be empty");
        }
    }

    @NotNull
    public final Comparator<CodeIndexedElement> getElementOrder() {
        return this.elementOrder;
    }

    @NotNull
    public String toString() {
        return "Package load order: " + this.packageOrder;
    }
}

