/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.parser;

import io.neos.fusion4j.lang.antlr.FusionParser;
import io.neos.fusion4j.lang.file.FusionSourceFileIdentifier;
import io.neos.fusion4j.lang.model.DslName;
import io.neos.fusion4j.lang.model.FusionPathName;
import io.neos.fusion4j.lang.model.PathNameSegmentQuoting;
import io.neos.fusion4j.lang.model.PropertyPathSegment;
import io.neos.fusion4j.lang.model.decl.RootFusionDecl;
import io.neos.fusion4j.lang.parser.DslParser;
import io.neos.fusion4j.lang.parser.FusionVisitorsKt;
import io.neos.fusion4j.lang.parser.RootFusionDeclVisitor;
import io.neos.fusion4j.lang.parser.StandaloneFusionPathVisitor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"log", "Lmu/KLogger;", "buildFusionMetaModel", "Lio/neos/fusion4j/lang/model/decl/RootFusionDecl;", "source", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "fusionFileContext", "Lio/neos/fusion4j/lang/antlr/FusionParser$FusionFileContext;", "dslParsers", "", "Lio/neos/fusion4j/lang/model/DslName;", "Lio/neos/fusion4j/lang/parser/DslParser;", "buildFusionPathMetaModel", "Lio/neos/fusion4j/lang/model/FusionPathName;", "fusionPathContext", "Lio/neos/fusion4j/lang/antlr/FusionParser$FusionPathContext;", "createIndexer", "Lkotlin/Function0;", "", "pathSegmentThatMayBeQuoted", "Lio/neos/fusion4j/lang/model/PropertyPathSegment;", "context", "Lorg/antlr/v4/runtime/tree/TerminalNode;", "lang"})
public final class FusionVisitorsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @NotNull
    public static final RootFusionDecl buildFusionMetaModel(@NotNull FusionSourceFileIdentifier source, @NotNull FusionParser.FusionFileContext fusionFileContext, @NotNull Map<DslName, ? extends DslParser> dslParsers) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)fusionFileContext), (String)"fusionFileContext");
        Intrinsics.checkNotNullParameter(dslParsers, (String)"dslParsers");
        Object t = fusionFileContext.accept(new RootFusionDeclVisitor(source, dslParsers));
        Intrinsics.checkNotNullExpressionValue(t, (String)"fusionFileContext.accept\u2026itor(source, dslParsers))");
        return (RootFusionDecl)t;
    }

    @NotNull
    public static final FusionPathName buildFusionPathMetaModel(@NotNull FusionParser.FusionPathContext fusionPathContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)fusionPathContext), (String)"fusionPathContext");
        Object t = fusionPathContext.accept(new StandaloneFusionPathVisitor());
        Intrinsics.checkNotNullExpressionValue(t, (String)"fusionPathContext.accept\u2026aloneFusionPathVisitor())");
        return (FusionPathName)t;
    }

    private static final Function0<Integer> createIndexer() {
        Ref.IntRef nextIndex = new Ref.IntRef();
        return (Function0)new Function0<Integer>(nextIndex){
            final /* synthetic */ Ref.IntRef $nextIndex;
            {
                this.$nextIndex = $nextIndex;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                int n = this.$nextIndex.element;
                this.$nextIndex.element = n + 1;
                return n;
            }
        };
    }

    private static final PropertyPathSegment pathSegmentThatMayBeQuoted(TerminalNode context) {
        String rawSegmentString = context.getText();
        Intrinsics.checkNotNullExpressionValue((Object)rawSegmentString, (String)"rawSegmentString");
        PathNameSegmentQuoting quoting = StringsKt.startsWith$default((CharSequence)rawSegmentString, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)rawSegmentString, (char)'\'', (boolean)false, (int)2, null) ? PathNameSegmentQuoting.SINGLE_QUOTED : (StringsKt.startsWith$default((CharSequence)rawSegmentString, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)rawSegmentString, (char)'\"', (boolean)false, (int)2, null) ? PathNameSegmentQuoting.DOUBLE_QUOTED : PathNameSegmentQuoting.NO_QUOTES);
        return switch (WhenMappings.$EnumSwitchMapping$0[quoting.ordinal()]) {
            case 1 -> PropertyPathSegment.Companion.create(rawSegmentString, quoting);
            case 2, 3 -> PropertyPathSegment.Companion.create(StringsKt.substring((String)rawSegmentString, (IntRange)RangesKt.until((int)1, (int)(rawSegmentString.length() - 1))), quoting);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ PropertyPathSegment access$pathSegmentThatMayBeQuoted(TerminalNode context) {
        return FusionVisitorsKt.pathSegmentThatMayBeQuoted(context);
    }

    public static final /* synthetic */ Function0 access$createIndexer() {
        return FusionVisitorsKt.createIndexer();
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathNameSegmentQuoting.values().length];
            nArray[PathNameSegmentQuoting.NO_QUOTES.ordinal()] = 1;
            nArray[PathNameSegmentQuoting.SINGLE_QUOTED.ordinal()] = 2;
            nArray[PathNameSegmentQuoting.DOUBLE_QUOTED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

