/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.model.values;

import io.neos.fusion4j.lang.model.decl.AstReference;
import io.neos.fusion4j.lang.model.values.FusionValue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/neos/fusion4j/lang/model/values/ExpressionValue;", "Lio/neos/fusion4j/lang/model/values/FusionValue;", "eelExpression", "", "astReference", "Lio/neos/fusion4j/lang/model/decl/AstReference;", "(Ljava/lang/String;Lio/neos/fusion4j/lang/model/decl/AstReference;)V", "getAstReference", "()Lio/neos/fusion4j/lang/model/decl/AstReference;", "getEelExpression", "()Ljava/lang/String;", "getOffendingExpressionAround", "startPosition", "", "numberOfLeadingContextChars", "numberOfTrailingContextChars", "getOffendingSymbol", "getReadableType", "getReadableValue", "toString", "Companion", "lang"})
public final class ExpressionValue
implements FusionValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String eelExpression;
    @NotNull
    private final AstReference astReference;
    @NotNull
    private static final Set<Character> SYMBOL_CHARS;

    public ExpressionValue(@NotNull String eelExpression, @NotNull AstReference astReference) {
        Intrinsics.checkNotNullParameter((Object)eelExpression, (String)"eelExpression");
        Intrinsics.checkNotNullParameter((Object)astReference, (String)"astReference");
        this.eelExpression = eelExpression;
        this.astReference = astReference;
    }

    @NotNull
    public final String getEelExpression() {
        return this.eelExpression;
    }

    @Override
    @NotNull
    public AstReference getAstReference() {
        return this.astReference;
    }

    @Override
    @NotNull
    public String getReadableType() {
        return "[EEL]";
    }

    @Override
    @NotNull
    public String getReadableValue() {
        return "${" + this.eelExpression + "}";
    }

    @NotNull
    public String toString() {
        return this.getReadableValue();
    }

    @NotNull
    public final String getOffendingSymbol(int startPosition) {
        String string2;
        int indexOfFirstNonSymbolChar;
        String restExpression;
        block5: {
            int n;
            String string3;
            if (startPosition > 0 && startPosition < this.eelExpression.length()) {
                String string4 = this.eelExpression.substring(startPosition - 1);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string3 = this.eelExpression;
            }
            restExpression = string3;
            CharSequence $this$indexOfFirst$iv = restExpression;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!SYMBOL_CHARS.contains(Character.valueOf(it)))) continue;
                n = index$iv;
                break block5;
            }
            n = indexOfFirstNonSymbolChar = -1;
        }
        if (indexOfFirstNonSymbolChar < 1) {
            string2 = restExpression;
        } else {
            String string5 = restExpression.substring(0, indexOfFirstNonSymbolChar);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string2;
    }

    @NotNull
    public final String getOffendingExpressionAround(int startPosition, int numberOfLeadingContextChars, int numberOfTrailingContextChars) {
        if (startPosition < 0 || startPosition > this.eelExpression.length()) {
            throw new IllegalArgumentException("Could not get offending expression, illegal starting position " + startPosition + "; must be between 0 and " + this.eelExpression.length() + " ");
        }
        String string2 = this.eelExpression.substring(Math.max(0, startPosition - numberOfLeadingContextChars), Math.max(0, startPosition - 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String leadingPart = string2;
        String string3 = this.eelExpression.substring(Math.max(0, startPosition - 1), Math.min(this.eelExpression.length(), startPosition - 1 + numberOfTrailingContextChars));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String problemPart = string3;
        return "(" + leadingPart + ")" + problemPart + " ...";
    }

    public static /* synthetic */ String getOffendingExpressionAround$default(ExpressionValue expressionValue, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 4;
        }
        if ((n4 & 4) != 0) {
            n3 = 20;
        }
        return expressionValue.getOffendingExpressionAround(n, n2, n3);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('_')};
        SYMBOL_CHARS = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z')))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9')))), (Iterable)SetsKt.setOf((Object[])objectArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/neos/fusion4j/lang/model/values/ExpressionValue$Companion;", "", "()V", "SYMBOL_CHARS", "", "", "getSYMBOL_CHARS", "()Ljava/util/Set;", "lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Character> getSYMBOL_CHARS() {
            return SYMBOL_CHARS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

