/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.file;

import io.neos.fusion4j.lang.file.FusionFile;
import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.file.FusionSourceFileIdentifier;
import io.neos.fusion4j.lang.model.FusionPackageName;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/neos/fusion4j/lang/file/InMemoryFusionFile;", "Lio/neos/fusion4j/lang/file/FusionFile;", "fileContent", "", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "fileName", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "(Ljava/lang/String;Lio/neos/fusion4j/lang/model/FusionPackageName;Lio/neos/fusion4j/lang/file/FusionResourceName;)V", "identifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "getIdentifier", "()Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getInputStream", "Ljava/io/InputStream;", "hashCode", "", "toString", "Companion", "lang"})
public final class InMemoryFusionFile
implements FusionFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileContent;
    @NotNull
    private final FusionPackageName packageName;
    @NotNull
    private final FusionResourceName fileName;
    @NotNull
    private final FusionSourceFileIdentifier identifier;
    @NotNull
    private static final String TYPE = "in-memory";

    public InMemoryFusionFile(@NotNull String fileContent, @NotNull FusionPackageName packageName, @NotNull FusionResourceName fileName) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileContent = fileContent;
        this.packageName = packageName;
        this.fileName = fileName;
        this.identifier = Companion.createSourceIdentifier(this.packageName, this.fileName);
    }

    @Override
    @NotNull
    public FusionSourceFileIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        byte[] byArray = this.fileContent.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new ByteArrayInputStream(byArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof InMemoryFusionFile && Objects.equals(this.getIdentifier(), ((InMemoryFusionFile)other).getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    private final String component1() {
        return this.fileContent;
    }

    private final FusionPackageName component2() {
        return this.packageName;
    }

    private final FusionResourceName component3() {
        return this.fileName;
    }

    @NotNull
    public final InMemoryFusionFile copy(@NotNull String fileContent, @NotNull FusionPackageName packageName, @NotNull FusionResourceName fileName) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new InMemoryFusionFile(fileContent, packageName, fileName);
    }

    public static /* synthetic */ InMemoryFusionFile copy$default(InMemoryFusionFile inMemoryFusionFile, String string2, FusionPackageName fusionPackageName, FusionResourceName fusionResourceName, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = inMemoryFusionFile.fileContent;
        }
        if ((n & 2) != 0) {
            fusionPackageName = inMemoryFusionFile.packageName;
        }
        if ((n & 4) != 0) {
            fusionResourceName = inMemoryFusionFile.fileName;
        }
        return inMemoryFusionFile.copy(string2, fusionPackageName, fusionResourceName);
    }

    @NotNull
    public String toString() {
        return "InMemoryFusionFile(fileContent=" + this.fileContent + ", packageName=" + this.packageName + ", fileName=" + this.fileName + ")";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/neos/fusion4j/lang/file/InMemoryFusionFile$Companion;", "", "()V", "TYPE", "", "createSourceIdentifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "fileName", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FusionSourceFileIdentifier createSourceIdentifier(@NotNull FusionPackageName packageName, @NotNull FusionResourceName fileName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new FusionSourceFileIdentifier(InMemoryFusionFile.TYPE, packageName, fileName, MapsKt.mapOf((Pair)TuplesKt.to((Object)"thread", (Object)Thread.currentThread().getName())));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

