/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.file;

import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.file.FusionSourceIdentifier;
import io.neos.fusion4j.lang.model.FusionPackageName;
import io.neos.fusion4j.lang.model.decl.AstReference;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J=\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u001bH\u00d6\u0001J\b\u0010'\u001a\u00020\u0003H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006)"}, d2={"Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "Lio/neos/fusion4j/lang/file/FusionSourceIdentifier;", "type", "", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "resourceName", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "metaDescription", "", "(Ljava/lang/String;Lio/neos/fusion4j/lang/model/FusionPackageName;Lio/neos/fusion4j/lang/file/FusionResourceName;Ljava/util/Map;)V", "identifier", "getIdentifier", "()Ljava/lang/String;", "getMetaDescription", "()Ljava/util/Map;", "getPackageName", "()Lio/neos/fusion4j/lang/model/FusionPackageName;", "parentDirectoryName", "getParentDirectoryName", "getResourceName", "()Lio/neos/fusion4j/lang/file/FusionResourceName;", "getType", "buildHintMessage", "astReference", "Lio/neos/fusion4j/lang/model/decl/AstReference;", "line", "", "char", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toReadableString", "toString", "lang"})
public final class FusionSourceFileIdentifier
implements FusionSourceIdentifier {
    @NotNull
    private final String type;
    @NotNull
    private final FusionPackageName packageName;
    @NotNull
    private final FusionResourceName resourceName;
    @NotNull
    private final Map<String, String> metaDescription;
    @NotNull
    private final String identifier;
    @NotNull
    private final String parentDirectoryName;

    public FusionSourceFileIdentifier(@NotNull String type, @NotNull FusionPackageName packageName, @NotNull FusionResourceName resourceName, @NotNull Map<String, String> metaDescription) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter(metaDescription, (String)"metaDescription");
        this.type = type;
        this.packageName = packageName;
        this.resourceName = resourceName;
        this.metaDescription = metaDescription;
        this.identifier = this.type + "://" + this.packageName.getName() + "/" + this.resourceName.getName();
        this.parentDirectoryName = this.resourceName.getParentDirectoryName();
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final FusionPackageName getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final FusionResourceName getResourceName() {
        return this.resourceName;
    }

    @NotNull
    public final Map<String, String> getMetaDescription() {
        return this.metaDescription;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final String getParentDirectoryName() {
        return this.parentDirectoryName;
    }

    @Override
    @NotNull
    public String toReadableString() {
        return this.identifier;
    }

    @NotNull
    public String toString() {
        return this.identifier;
    }

    @NotNull
    public final String buildHintMessage(int line, int n) {
        Iterable $this$sortedBy$iv = this.metaDescription.entrySet();
        boolean $i$f$sortedBy = false;
        return StringsKt.replace$default((String)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        }).toString(), (String)this.resourceName.getName(), (String)(this.resourceName.getName() + ":" + line + ":" + n), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String buildHintMessage(@NotNull AstReference astReference) {
        Intrinsics.checkNotNullParameter((Object)astReference, (String)"astReference");
        return this.buildHintMessage(astReference.getStartPosition().getLine(), astReference.getStartPosition().getCharPositionInLine());
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final FusionPackageName component2() {
        return this.packageName;
    }

    @NotNull
    public final FusionResourceName component3() {
        return this.resourceName;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.metaDescription;
    }

    @NotNull
    public final FusionSourceFileIdentifier copy(@NotNull String type, @NotNull FusionPackageName packageName, @NotNull FusionResourceName resourceName, @NotNull Map<String, String> metaDescription) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter(metaDescription, (String)"metaDescription");
        return new FusionSourceFileIdentifier(type, packageName, resourceName, metaDescription);
    }

    public static /* synthetic */ FusionSourceFileIdentifier copy$default(FusionSourceFileIdentifier fusionSourceFileIdentifier, String string2, FusionPackageName fusionPackageName, FusionResourceName fusionResourceName, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = fusionSourceFileIdentifier.type;
        }
        if ((n & 2) != 0) {
            fusionPackageName = fusionSourceFileIdentifier.packageName;
        }
        if ((n & 4) != 0) {
            fusionResourceName = fusionSourceFileIdentifier.resourceName;
        }
        if ((n & 8) != 0) {
            map = fusionSourceFileIdentifier.metaDescription;
        }
        return fusionSourceFileIdentifier.copy(string2, fusionPackageName, fusionResourceName, map);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.packageName.hashCode();
        result = result * 31 + this.resourceName.hashCode();
        result = result * 31 + ((Object)this.metaDescription).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FusionSourceFileIdentifier)) {
            return false;
        }
        FusionSourceFileIdentifier fusionSourceFileIdentifier = (FusionSourceFileIdentifier)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)fusionSourceFileIdentifier.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)fusionSourceFileIdentifier.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resourceName, (Object)fusionSourceFileIdentifier.resourceName)) {
            return false;
        }
        return Intrinsics.areEqual(this.metaDescription, fusionSourceFileIdentifier.metaDescription);
    }
}

