/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.file;

import io.neos.fusion4j.lang.file.FilesystemFusionFile;
import io.neos.fusion4j.lang.file.FusionFile;
import io.neos.fusion4j.lang.file.FusionPackageLoader;
import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.model.FusionPackageName;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lio/neos/fusion4j/lang/file/FusionPackageDefinition;", "", "fusionFiles", "", "Lio/neos/fusion4j/lang/file/FusionFile;", "descriptor", "Lio/neos/fusion4j/lang/file/FusionPackageLoader$FusionPackageLoaderDescriptor;", "(Ljava/util/Set;Lio/neos/fusion4j/lang/file/FusionPackageLoader$FusionPackageLoaderDescriptor;)V", "getDescriptor", "()Lio/neos/fusion4j/lang/file/FusionPackageLoader$FusionPackageLoaderDescriptor;", "entrypoint", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "getEntrypoint", "()Lio/neos/fusion4j/lang/file/FusionResourceName;", "entrypointFile", "getEntrypointFile", "()Lio/neos/fusion4j/lang/file/FusionFile;", "getFusionFiles", "()Ljava/util/Set;", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "getPackageName", "()Lio/neos/fusion4j/lang/model/FusionPackageName;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "lang"})
public final class FusionPackageDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<FusionFile> fusionFiles;
    @NotNull
    private final FusionPackageLoader.FusionPackageLoaderDescriptor descriptor;
    @NotNull
    private final FusionPackageName packageName;
    @NotNull
    private final FusionResourceName entrypoint;

    public FusionPackageDefinition(@NotNull Set<? extends FusionFile> fusionFiles, @NotNull FusionPackageLoader.FusionPackageLoaderDescriptor descriptor) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(fusionFiles, (String)"fusionFiles");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.fusionFiles = fusionFiles;
            this.descriptor = descriptor;
            this.packageName = this.descriptor.getPackageName();
            this.entrypoint = this.descriptor.getEntrypoint();
            Iterable $this$none$iv = this.fusionFiles;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FusionFile it = (FusionFile)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)this.entrypoint, (Object)it.getIdentifier().getResourceName())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("invalid package " + this.packageName + "; entrypoint " + this.entrypoint + " not found in Fusion files: " + this.fusionFiles);
        }
    }

    @NotNull
    public final Set<FusionFile> getFusionFiles() {
        return this.fusionFiles;
    }

    @NotNull
    public final FusionPackageLoader.FusionPackageLoaderDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final FusionPackageName getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final FusionResourceName getEntrypoint() {
        return this.entrypoint;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FusionFile getEntrypointFile() {
        void var3_3;
        Iterable $this$single$iv = this.fusionFiles;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            FusionFile it = (FusionFile)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getIdentifier().getResourceName(), (Object)this.entrypoint)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (FusionFile)var3_3;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FusionPackageDefinition && Intrinsics.areEqual((Object)this.packageName, (Object)((FusionPackageDefinition)other).packageName);
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    @NotNull
    public final Set<FusionFile> component1() {
        return this.fusionFiles;
    }

    @NotNull
    public final FusionPackageLoader.FusionPackageLoaderDescriptor component2() {
        return this.descriptor;
    }

    @NotNull
    public final FusionPackageDefinition copy(@NotNull Set<? extends FusionFile> fusionFiles, @NotNull FusionPackageLoader.FusionPackageLoaderDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(fusionFiles, (String)"fusionFiles");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FusionPackageDefinition(fusionFiles, descriptor);
    }

    public static /* synthetic */ FusionPackageDefinition copy$default(FusionPackageDefinition fusionPackageDefinition, Set set, FusionPackageLoader.FusionPackageLoaderDescriptor fusionPackageLoaderDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            set = fusionPackageDefinition.fusionFiles;
        }
        if ((n & 2) != 0) {
            fusionPackageLoaderDescriptor = fusionPackageDefinition.descriptor;
        }
        return fusionPackageDefinition.copy(set, fusionPackageLoaderDescriptor);
    }

    @NotNull
    public String toString() {
        return "FusionPackageDefinition(fusionFiles=" + this.fusionFiles + ", descriptor=" + this.descriptor + ")";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/neos/fusion4j/lang/file/FusionPackageDefinition$Companion;", "", "()V", "loadAsFileSystemPackage", "Lio/neos/fusion4j/lang/file/FusionPackageDefinition;", "descriptor", "Lio/neos/fusion4j/lang/file/FusionPackageLoader$FusionPackageLoaderDescriptor;", "packageBasePath", "Ljava/nio/file/Path;", "lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FusionPackageDefinition loadAsFileSystemPackage(@NotNull FusionPackageLoader.FusionPackageLoaderDescriptor descriptor, @NotNull Path packageBasePath) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)packageBasePath, (String)"packageBasePath");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(packageBasePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new IllegalArgumentException("Could not load Fusion package from filesystem; package base path " + packageBasePath + " does not exist");
            }
            return new FusionPackageDefinition(FilesystemFusionFile.Companion.findAllFusionFilesInBasePath(descriptor.getPackageName(), packageBasePath), descriptor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

