/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.file;

import io.neos.fusion4j.lang.file.FusionFile;
import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.file.FusionSourceFileIdentifier;
import io.neos.fusion4j.lang.model.FusionPackageName;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/neos/fusion4j/lang/file/FilesystemFusionFile;", "Lio/neos/fusion4j/lang/file/FusionFile;", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "packagePath", "Ljava/nio/file/Path;", "filePath", "(Lio/neos/fusion4j/lang/model/FusionPackageName;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "identifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "getIdentifier", "()Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "equals", "", "other", "", "getInputStream", "Ljava/io/InputStream;", "hashCode", "", "toString", "", "Companion", "lang"})
public final class FilesystemFusionFile
implements FusionFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path filePath;
    @NotNull
    private final FusionSourceFileIdentifier identifier;
    @NotNull
    public static final String TYPE = "file";

    public FilesystemFusionFile(@NotNull FusionPackageName packageName, @NotNull Path packagePath, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.identifier = Companion.createIdentifier(packageName, this.filePath, packagePath);
        if (!FilesystemFusionFile.Companion.validateChildPathOf(packagePath, this.filePath)) {
            throw new IllegalArgumentException("package path " + packagePath + " must be a child of " + this.filePath);
        }
    }

    @Override
    @NotNull
    public FusionSourceFileIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new FileInputStream(this.filePath.toFile());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FilesystemFusionFile && Objects.equals(this.getIdentifier(), ((FilesystemFusionFile)other).getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getIdentifier().toReadableString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/neos/fusion4j/lang/file/FilesystemFusionFile$Companion;", "", "()V", "TYPE", "", "classpathToFilesystemIdentifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "packageBasePath", "Ljava/nio/file/Path;", "source", "createIdentifier", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "filePath", "packagePath", "findAllFusionFilesInBasePath", "", "Lio/neos/fusion4j/lang/file/FilesystemFusionFile;", "basePath", "isFusionFile", "", "file", "Ljava/io/File;", "validateChildPathOf", "parent", "child", "lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<FilesystemFusionFile> findAllFusionFilesInBasePath(@NotNull FusionPackageName packageName, @NotNull Path basePath) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            File file = basePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"basePath.toFile()");
            return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>((Object)this){

                @NotNull
                public final Boolean invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Companion)this.receiver).isFusionFile(p0);
                }
            })), (Function1)((Function1)new Function1<File, FilesystemFusionFile>(packageName, basePath){
                final /* synthetic */ FusionPackageName $packageName;
                final /* synthetic */ Path $basePath;
                {
                    this.$packageName = $packageName;
                    this.$basePath = $basePath;
                    super(1);
                }

                @NotNull
                public final FilesystemFusionFile invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Path path = it.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                    return new FilesystemFusionFile(this.$packageName, this.$basePath, path);
                }
            })));
        }

        public final boolean isFusionFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)FilesystemFusionFile.TYPE);
            return file.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"fusion");
        }

        @NotNull
        public final FusionSourceFileIdentifier createIdentifier(@NotNull FusionPackageName packageName, @NotNull Path filePath, @NotNull Path packagePath) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)packagePath, (String)"packagePath");
            Path path = packagePath.relativize(filePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"packagePath.relativize(filePath)");
            FusionResourceName fusionResourceName = new FusionResourceName(((Object)path).toString());
            Path path2 = filePath.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath()");
            Path path3 = path2.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"filePath\n               \u2026             .normalize()");
            return new FusionSourceFileIdentifier(FilesystemFusionFile.TYPE, packageName, fusionResourceName, MapsKt.mapOf((Pair)TuplesKt.to((Object)FilesystemFusionFile.TYPE, (Object)((Object)path3).toString())));
        }

        @NotNull
        public final FusionSourceFileIdentifier classpathToFilesystemIdentifier(@NotNull Path packageBasePath, @NotNull FusionSourceFileIdentifier source) {
            Intrinsics.checkNotNullParameter((Object)packageBasePath, (String)"packageBasePath");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!Intrinsics.areEqual((Object)source.getType(), (Object)"classpath")) {
                throw new IllegalArgumentException("Could not convert identifier " + source + " to filesystem identifier; type must be 'file' but was '" + source.getType() + "'");
            }
            FusionPackageName fusionPackageName = source.getPackageName();
            Path path = packageBasePath.resolve(source.getResourceName().getName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"packageBasePath.resolve(source.resourceName.name)");
            return this.createIdentifier(fusionPackageName, path, packageBasePath);
        }

        private final boolean validateChildPathOf(Path parent, Path child) {
            if (child == null) {
                return false;
            }
            Path path = parent.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath()");
            Path parentNormalized = path.normalize();
            Path path2 = child.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath()");
            Path childNormalized = path2.normalize();
            if (Intrinsics.areEqual((Object)parentNormalized, (Object)childNormalized)) {
                return true;
            }
            return this.validateChildPathOf(parent, child.getParent());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

