/*
 * Decompiled with CFR 0.152.
 */
package io.neos.fusion4j.lang.file;

import io.neos.fusion4j.lang.file.FusionFile;
import io.neos.fusion4j.lang.file.FusionResourceName;
import io.neos.fusion4j.lang.file.FusionSourceFileIdentifier;
import io.neos.fusion4j.lang.model.FusionPackageName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\tH\u00c2\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/neos/fusion4j/lang/file/ClasspathFusionFile;", "Lio/neos/fusion4j/lang/file/FusionFile;", "classLoader", "Ljava/lang/ClassLoader;", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "fullResourceName", "", "resourceName", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "(Ljava/lang/ClassLoader;Lio/neos/fusion4j/lang/model/FusionPackageName;Ljava/lang/String;Lio/neos/fusion4j/lang/file/FusionResourceName;)V", "identifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "getIdentifier", "()Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getInputStream", "Ljava/io/InputStream;", "hashCode", "", "toString", "Companion", "lang"})
public final class ClasspathFusionFile
implements FusionFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final FusionPackageName packageName;
    @NotNull
    private final String fullResourceName;
    @NotNull
    private final FusionResourceName resourceName;
    @NotNull
    private final FusionSourceFileIdentifier identifier;
    @NotNull
    public static final String TYPE = "classpath";

    public ClasspathFusionFile(@NotNull ClassLoader classLoader, @NotNull FusionPackageName packageName, @NotNull String fullResourceName, @NotNull FusionResourceName resourceName) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fullResourceName, (String)"fullResourceName");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        this.classLoader = classLoader;
        this.packageName = packageName;
        this.fullResourceName = fullResourceName;
        this.resourceName = resourceName;
        this.identifier = Companion.createFileIdentifier(this.packageName, this.resourceName, this.fullResourceName);
    }

    @Override
    @NotNull
    public FusionSourceFileIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.classLoader.getResourceAsStream(this.fullResourceName);
        if (inputStream == null) {
            throw new IllegalStateException("No classpath resource found for Fusion file " + this);
        }
        return inputStream;
    }

    @NotNull
    public String toString() {
        return this.getIdentifier().toReadableString() + " (resource: " + this.fullResourceName + ")";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ClasspathFusionFile && Objects.equals(this.getIdentifier(), ((ClasspathFusionFile)other).getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    private final ClassLoader component1() {
        return this.classLoader;
    }

    private final FusionPackageName component2() {
        return this.packageName;
    }

    private final String component3() {
        return this.fullResourceName;
    }

    private final FusionResourceName component4() {
        return this.resourceName;
    }

    @NotNull
    public final ClasspathFusionFile copy(@NotNull ClassLoader classLoader, @NotNull FusionPackageName packageName, @NotNull String fullResourceName, @NotNull FusionResourceName resourceName) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fullResourceName, (String)"fullResourceName");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return new ClasspathFusionFile(classLoader, packageName, fullResourceName, resourceName);
    }

    public static /* synthetic */ ClasspathFusionFile copy$default(ClasspathFusionFile classpathFusionFile, ClassLoader classLoader, FusionPackageName fusionPackageName, String string2, FusionResourceName fusionResourceName, int n, Object object) {
        if ((n & 1) != 0) {
            classLoader = classpathFusionFile.classLoader;
        }
        if ((n & 2) != 0) {
            fusionPackageName = classpathFusionFile.packageName;
        }
        if ((n & 4) != 0) {
            string2 = classpathFusionFile.fullResourceName;
        }
        if ((n & 8) != 0) {
            fusionResourceName = classpathFusionFile.resourceName;
        }
        return classpathFusionFile.copy(classLoader, fusionPackageName, string2, fusionResourceName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/neos/fusion4j/lang/file/ClasspathFusionFile$Companion;", "", "()V", "TYPE", "", "createFileIdentifier", "Lio/neos/fusion4j/lang/file/FusionSourceFileIdentifier;", "packageName", "Lio/neos/fusion4j/lang/model/FusionPackageName;", "resourceName", "Lio/neos/fusion4j/lang/file/FusionResourceName;", "fullResourceName", "scanAllFusionFilesOnClasspath", "", "Lio/neos/fusion4j/lang/file/ClasspathFusionFile;", "classLoader", "Ljava/lang/ClassLoader;", "loadPackageName", "excludedPatterns", "scanClasspathExcludingTests", "loadPackageNames", "lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FusionSourceFileIdentifier createFileIdentifier(@NotNull FusionPackageName packageName, @NotNull FusionResourceName resourceName, @NotNull String fullResourceName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter((Object)fullResourceName, (String)"fullResourceName");
            return new FusionSourceFileIdentifier(ClasspathFusionFile.TYPE, packageName, resourceName, MapsKt.mapOf((Pair)TuplesKt.to((Object)"resource", (Object)fullResourceName)));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<ClasspathFusionFile> scanAllFusionFilesOnClasspath(@NotNull ClassLoader classLoader, @NotNull FusionPackageName packageName, @NotNull String loadPackageName, @NotNull Set<String> excludedPatterns) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)loadPackageName, (String)"loadPackageName");
            Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
            Iterable iterable = excludedPatterns;
            Object initial$iv = new FilterBuilder().includePackage(loadPackageName);
            boolean $i$f$fold = false;
            Scanner[] accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void pattern;
                String string2 = (String)element$iv;
                Scanner[] filter = accumulator$iv;
                boolean bl = false;
                accumulator$iv = filter.excludePattern((String)pattern);
            }
            Scanner[] filter = accumulator$iv;
            initial$iv = new Scanner[]{classLoader};
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addClassLoaders((ClassLoader[])initial$iv).forPackage(loadPackageName, new ClassLoader[0]).filterInputsBy((Predicate)filter);
            initial$iv = new Scanner[]{(Scanner)Scanners.Resources};
            Reflections reflections = new Reflections((Configuration)configurationBuilder.setScanners(initial$iv));
            Set set = reflections.get(Scanners.Resources.with(".*\\.fusion"));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"reflections.get(Scanners\u2026rces.with(\".*\\\\.fusion\"))");
            initial$iv = set;
            boolean $i$f$map = false;
            accumulator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string3 = it.substring(loadPackageName.length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                collection.add(new ClasspathFusionFile(classLoader, packageName, (String)it, new FusionResourceName(string3)));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public static /* synthetic */ Set scanAllFusionFilesOnClasspath$default(Companion companion, ClassLoader classLoader, FusionPackageName fusionPackageName, String string2, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = fusionPackageName.getName();
            }
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            return companion.scanAllFusionFilesOnClasspath(classLoader, fusionPackageName, string2, set);
        }

        @NotNull
        public final Set<ClasspathFusionFile> scanClasspathExcludingTests(@NotNull ClassLoader classLoader, @NotNull FusionPackageName packageName, @NotNull String loadPackageName, @NotNull Set<String> excludedPatterns) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)loadPackageName, (String)"loadPackageName");
            Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
            Object[] objectArray = new String[]{".*\\.Tests\\.Unit\\..*", ".*\\.Tests\\.Functional\\..*", ".*\\.Tests\\.Behavior\\..*"};
            return this.scanAllFusionFilesOnClasspath(classLoader, packageName, loadPackageName, SetsKt.plus(excludedPatterns, (Iterable)SetsKt.setOf((Object[])objectArray)));
        }

        public static /* synthetic */ Set scanClasspathExcludingTests$default(Companion companion, ClassLoader classLoader, FusionPackageName fusionPackageName, String string2, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = fusionPackageName.getName();
            }
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            return companion.scanClasspathExcludingTests(classLoader, fusionPackageName, string2, (Set<String>)set);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<ClasspathFusionFile> scanClasspathExcludingTests(@NotNull ClassLoader classLoader, @NotNull FusionPackageName packageName, @NotNull Set<String> loadPackageNames, @NotNull Set<String> excludedPatterns) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(loadPackageNames, (String)"loadPackageNames");
            Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
            Iterable iterable = loadPackageNames;
            boolean $i$f$flatMap = false;
            void var7_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = Companion.scanClasspathExcludingTests(classLoader, packageName, it, excludedPatterns);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public static /* synthetic */ Set scanClasspathExcludingTests$default(Companion companion, ClassLoader classLoader, FusionPackageName fusionPackageName, Set set, Set set2, int n, Object object) {
            if ((n & 8) != 0) {
                set2 = SetsKt.emptySet();
            }
            return companion.scanClasspathExcludingTests(classLoader, fusionPackageName, set, (Set<String>)set2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

