/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyRevocationTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyRevocationTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicSupplyRevocationTransactionDTO;

class MosaicSupplyRevocationTransactionMapper
extends AbstractTransactionMapper<MosaicSupplyRevocationTransactionDTO, MosaicSupplyRevocationTransaction> {
    public MosaicSupplyRevocationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_SUPPLY_REVOCATION, MosaicSupplyRevocationTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicSupplyRevocationTransaction> createFactory(NetworkType networkType, Deadline deadline, MosaicSupplyRevocationTransactionDTO transaction) {
        return MosaicSupplyRevocationTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getSourceAddress()), (Mosaic)this.getMosaic(transaction));
    }

    @Override
    protected void copyToDto(MosaicSupplyRevocationTransaction transaction, MosaicSupplyRevocationTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaic().getId()));
        dto.setAmount(transaction.getMosaic().getAmount());
        dto.setSourceAddress(transaction.getSourceAddress().encoded(transaction.getNetworkType()));
    }

    private Mosaic getMosaic(MosaicSupplyRevocationTransactionDTO transaction) {
        return new Mosaic(MapperUtils.toUnresolvedMosaicId((String)transaction.getMosaicId()), transaction.getAmount());
    }
}

