/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.AliasAction;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicAliasTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicAliasTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AliasActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAliasTransactionDTO;

class MosaicAliasTransactionMapper
extends AbstractTransactionMapper<MosaicAliasTransactionDTO, MosaicAliasTransaction> {
    public MosaicAliasTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_ALIAS, MosaicAliasTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicAliasTransaction> createFactory(NetworkType networkType, Deadline deadline, MosaicAliasTransactionDTO transaction) {
        NamespaceId namespaceId = MapperUtils.toNamespaceId((String)transaction.getNamespaceId());
        AliasAction aliasAction = AliasAction.rawValueOf((byte)transaction.getAliasAction().getValue().byteValue());
        return MosaicAliasTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (AliasAction)aliasAction, (NamespaceId)namespaceId, (MosaicId)MapperUtils.toMosaicId((String)transaction.getMosaicId()));
    }

    @Override
    protected void copyToDto(MosaicAliasTransaction transaction, MosaicAliasTransactionDTO dto) {
        dto.setAliasAction(AliasActionEnum.fromValue((Integer)Integer.valueOf(transaction.getAliasAction().getValue())));
        dto.setNamespaceId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
    }
}

