/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountMosaicRestrictionTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountMosaicRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountMosaicRestrictionTransactionDTO, AccountMosaicRestrictionTransaction> {
    public AccountMosaicRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_MOSAIC_RESTRICTION, AccountMosaicRestrictionTransactionDTO.class);
    }

    protected AccountMosaicRestrictionTransactionFactory createFactory(NetworkType networkType, Deadline deadline, AccountMosaicRestrictionTransactionDTO transaction) {
        AccountMosaicRestrictionFlags restrictionFlags = AccountMosaicRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List additions = transaction.getRestrictionAdditions().stream().map(MapperUtils::toUnresolvedMosaicId).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::toUnresolvedMosaicId).collect(Collectors.toList());
        return AccountMosaicRestrictionTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (AccountMosaicRestrictionFlags)restrictionFlags, additions, deletions);
    }

    @Override
    protected void copyToDto(AccountMosaicRestrictionTransaction transaction, AccountMosaicRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        List additions = transaction.getRestrictionAdditions().stream().map(MapperUtils::getIdAsHex).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::getIdAsHex).collect(Collectors.toList());
        dto.setRestrictionAdditions(additions);
        dto.setRestrictionDeletions(deletions);
    }
}

