/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.TransactionRepository;
import io.nem.symbol.sdk.api.TransactionSearchCriteria;
import io.nem.symbol.sdk.infrastructure.TransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionAnnounceResponse;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TransactionRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements TransactionRepository {
    private final TransactionRoutesApi client;
    private final TransactionMapper transactionMapper;

    public TransactionRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new TransactionRoutesApiImpl(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public TransactionRoutesApi getClient() {
        return this.client;
    }

    public Observable<Page<Transaction>> search(TransactionSearchCriteria criteria) {
        Consumer callback = this.getSearchHandler(criteria);
        return this.exceptionHandling(this.call(callback).map(p -> {
            List data = p.getData().stream().map(transactionDto -> this.mapTransaction(criteria.getGroup(), (TransactionInfoDTO)transactionDto)).collect(Collectors.toList());
            return this.toPage(p.getPagination(), data);
        }));
    }

    private List<TransactionTypeEnum> toDto(List<TransactionType> transactionTypes) {
        return transactionTypes == null ? null : transactionTypes.stream().map(e -> TransactionTypeEnum.fromValue((Integer)e.getValue())).collect(Collectors.toList());
    }

    public Observable<Transaction> getTransaction(TransactionGroup group, String transactionHash) {
        Consumer callback = this.getTransactionHandler(group, transactionHash);
        return this.call(callback, transactionDto -> this.mapTransaction(group, (TransactionInfoDTO)transactionDto));
    }

    public Observable<List<Transaction>> getTransactions(TransactionGroup group, List<String> transactionHashes) {
        Consumer callback = this.getTransactionsHandler(group, transactionHashes);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(transactionDto -> this.mapTransaction(group, (TransactionInfoDTO)transactionDto)).toList().toObservable());
    }

    public Observable<TransactionAnnounceResponse> announce(SignedTransaction signedTransaction) {
        Consumer callback = handler -> this.getClient().announceTransaction(new TransactionPayload().payload(signedTransaction.getPayload()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBonded(SignedTransaction signedTransaction) {
        Consumer callback = handler -> this.getClient().announcePartialTransaction(new TransactionPayload().payload(signedTransaction.getPayload()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBondedCosignature(CosignatureSignedTransaction cosignatureSignedTransaction) {
        Consumer callback = handler -> this.getClient().announceCosignatureTransaction(new Cosignature().parentHash(cosignatureSignedTransaction.getParentHash()).version(cosignatureSignedTransaction.getVersion()).signature(cosignatureSignedTransaction.getSignature()).signerPublicKey(cosignatureSignedTransaction.getSigner().getPublicKey().toHex()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    private Consumer<Handler<AsyncResult<List<TransactionInfoDTO>>>> getTransactionsHandler(TransactionGroup group, List<String> transactionHashes) {
        TransactionIds transactionIds = new TransactionIds().transactionIds(transactionHashes);
        switch (group) {
            case CONFIRMED: {
                return handler -> this.client.getConfirmedTransactions(transactionIds, handler);
            }
            case PARTIAL: {
                return handler -> this.client.getPartialTransactions(transactionIds, handler);
            }
            case UNCONFIRMED: {
                return handler -> this.client.getUnconfirmedTransactions(transactionIds, handler);
            }
        }
        throw new IllegalArgumentException("Invalid group " + group);
    }

    private Consumer<Handler<AsyncResult<TransactionInfoDTO>>> getTransactionHandler(TransactionGroup group, String transactionHash) {
        switch (group) {
            case CONFIRMED: {
                return handler -> this.getClient().getConfirmedTransaction(transactionHash, handler);
            }
            case PARTIAL: {
                return handler -> this.getClient().getPartialTransaction(transactionHash, handler);
            }
            case UNCONFIRMED: {
                return handler -> this.getClient().getUnconfirmedTransaction(transactionHash, handler);
            }
        }
        throw new IllegalArgumentException("Invalid group " + group);
    }

    private Consumer<Handler<AsyncResult<TransactionPage>>> getSearchHandler(TransactionSearchCriteria criteria) {
        switch (criteria.getGroup()) {
            case CONFIRMED: {
                return handler -> this.getClient().searchConfirmedTransactions(this.toDto(criteria.getAddress()), this.toDto(criteria.getRecipientAddress()), this.toDto(criteria.getSignerPublicKey()), criteria.getHeight(), criteria.getFromHeight(), criteria.getToHeight(), criteria.getFromTransferAmount(), criteria.getToTransferAmount(), this.toDto(criteria.getTransactionTypes()), criteria.getEmbedded(), this.toDto(criteria.getTransferMosaicId()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), handler);
            }
            case UNCONFIRMED: {
                return handler -> this.getClient().searchUnconfirmedTransactions(this.toDto(criteria.getAddress()), this.toDto(criteria.getRecipientAddress()), this.toDto(criteria.getSignerPublicKey()), criteria.getHeight(), criteria.getFromHeight(), criteria.getToHeight(), criteria.getFromTransferAmount(), criteria.getToTransferAmount(), this.toDto(criteria.getTransactionTypes()), criteria.getEmbedded(), this.toDto(criteria.getTransferMosaicId()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), handler);
            }
            case PARTIAL: {
                return handler -> this.getClient().searchPartialTransactions(this.toDto(criteria.getAddress()), this.toDto(criteria.getRecipientAddress()), this.toDto(criteria.getSignerPublicKey()), criteria.getHeight(), criteria.getFromHeight(), criteria.getToHeight(), criteria.getFromTransferAmount(), criteria.getToTransferAmount(), this.toDto(criteria.getTransactionTypes()), criteria.getEmbedded(), this.toDto(criteria.getTransferMosaicId()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), handler);
            }
        }
        throw new IllegalArgumentException("Invalid group " + criteria.getGroup());
    }

    private Transaction mapTransaction(TransactionGroup group, TransactionInfoDTO transactionDto) {
        return this.transactionMapper.mapToFactoryFromDto((Object)transactionDto).group(group).build();
    }
}

