/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MosaicRestrictionSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.RestrictionMosaicRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.restriction.MosaicAddressRestriction;
import io.nem.symbol.sdk.model.restriction.MosaicGlobalRestriction;
import io.nem.symbol.sdk.model.restriction.MosaicGlobalRestrictionItem;
import io.nem.symbol.sdk.model.restriction.MosaicRestriction;
import io.nem.symbol.sdk.model.restriction.MosaicRestrictionEntryType;
import io.nem.symbol.sdk.model.transaction.MosaicRestrictionType;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionEntryWrapperDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionEntryRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionEntryWrapperDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicRestrictionEntryTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class RestrictionMosaicRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements RestrictionMosaicRepository {
    private final RestrictionMosaicRoutesApi client;

    public RestrictionMosaicRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new RestrictionMosaicRoutesApiImpl(apiClient);
    }

    private MosaicGlobalRestriction toMosaicGlobalRestriction(MosaicGlobalRestrictionDTO mosaicGlobalRestrictionDTO) {
        MosaicGlobalRestrictionEntryWrapperDTO dto = mosaicGlobalRestrictionDTO.getMosaicRestrictionEntry();
        Map restrictions = dto.getRestrictions().stream().collect(Collectors.toMap(e -> new BigInteger(e.getKey()), e -> this.toMosaicGlobalRestrictionItem(e.getRestriction()), (x, y) -> y, LinkedHashMap::new));
        return new MosaicGlobalRestriction(mosaicGlobalRestrictionDTO.getId(), ((Integer)ObjectUtils.defaultIfNull((Object)mosaicGlobalRestrictionDTO.getMosaicRestrictionEntry().getVersion(), (Object)1)).intValue(), dto.getCompositeHash(), MosaicRestrictionEntryType.rawValueOf((int)dto.getEntryType().getValue()), MapperUtils.toMosaicId((String)dto.getMosaicId()), restrictions);
    }

    private MosaicGlobalRestrictionItem toMosaicGlobalRestrictionItem(MosaicGlobalRestrictionEntryRestrictionDTO dto) {
        return new MosaicGlobalRestrictionItem(MapperUtils.toMosaicId((String)dto.getReferenceMosaicId()), dto.getRestrictionValue(), MosaicRestrictionType.rawValueOf((byte)dto.getRestrictionType().getValue().byteValue()));
    }

    private MosaicAddressRestriction toMosaicAddressRestriction(MosaicAddressRestrictionDTO mosaicAddressRestrictionDTO) {
        MosaicAddressRestrictionEntryWrapperDTO dto = mosaicAddressRestrictionDTO.getMosaicRestrictionEntry();
        Map<BigInteger, BigInteger> restrictions = dto.getRestrictions().stream().collect(Collectors.toMap(e -> new BigInteger(e.getKey()), e -> this.toBigInteger(e.getValue())));
        return new MosaicAddressRestriction(mosaicAddressRestrictionDTO.getId(), ((Integer)ObjectUtils.defaultIfNull((Object)dto.getVersion(), (Object)1)).intValue(), dto.getCompositeHash(), MosaicRestrictionEntryType.rawValueOf((int)dto.getEntryType().getValue()), MapperUtils.toMosaicId((String)dto.getMosaicId()), MapperUtils.toAddress((String)dto.getTargetAddress()), restrictions);
    }

    private BigInteger toBigInteger(String value) {
        return new BigInteger(value);
    }

    public RestrictionMosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<Page<MosaicRestriction<?>>> search(MosaicRestrictionSearchCriteria criteria) {
        String mosaicId = criteria.getMosaicId() == null ? null : criteria.getMosaicId().getIdAsHex();
        MosaicRestrictionEntryTypeEnum entryType = criteria.getEntryType() == null ? null : MosaicRestrictionEntryTypeEnum.fromValue((Integer)criteria.getEntryType().getValue());
        String targetAddress = this.toDto(criteria.getTargetAddress());
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = h -> this.getClient().searchMosaicRestrictions(mosaicId, entryType, targetAddress, pageSize, pageNumber, offset, order, h);
        return this.call(callback, page -> this.toPage(page.getPagination(), page.getData().stream().map(this::toMosaicRestriction).collect(Collectors.toList())));
    }

    private MosaicRestriction<?> toMosaicRestriction(Object restrictionObject) {
        MosaicRestrictionEntryType thisEntryType = MosaicRestrictionEntryType.rawValueOf((int)this.getJsonHelper().getInteger(restrictionObject, new String[]{"mosaicRestrictionEntry", "entryType"}));
        switch (thisEntryType) {
            case ADDRESS: {
                return this.toMosaicAddressRestriction((MosaicAddressRestrictionDTO)this.getJsonHelper().convert(restrictionObject, MosaicAddressRestrictionDTO.class, new String[0]));
            }
            case GLOBAL: {
                return this.toMosaicGlobalRestriction((MosaicGlobalRestrictionDTO)this.getJsonHelper().convert(restrictionObject, MosaicGlobalRestrictionDTO.class, new String[0]));
            }
        }
        throw new IllegalStateException("Invalid entry type " + thisEntryType);
    }

    public Observable<MosaicRestriction<?>> getMosaicRestrictions(String compositeHash) {
        return this.call(h -> this.getClient().getMosaicRestrictions(compositeHash, h), this::toMosaicRestriction);
    }

    public Observable<MerkleStateInfo> getMosaicRestrictionsMerkle(String compositeHash) {
        return this.call(h -> this.getClient().getMosaicRestrictionsMerkle(compositeHash, h), this::toMerkleStateInfo);
    }
}

