/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.nem.symbol.sdk.api.Listener;
import io.nem.symbol.sdk.api.MultisigRepository;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.infrastructure.ListenerBase;
import io.nem.symbol.sdk.infrastructure.ListenerSubscribeMessage;
import io.nem.symbol.sdk.infrastructure.TransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.BlockRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.ChainRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.FinalizedBlock;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.FinalizedBlockDTO;
import io.reactivex.Observable;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.Json;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ListenerVertx
extends ListenerBase
implements Listener {
    private final URL url;
    private final HttpClient httpClient;
    private final TransactionMapper transactionMapper;
    private WebSocket webSocket;

    public ListenerVertx(HttpClient httpClient, String url, NamespaceRepository namespaceRepository, MultisigRepository multisigRepository, Observable<NetworkType> networkTypeObservable) {
        super((JsonHelper)new JsonHelperJackson2(JsonHelperJackson2.configureMapper(Json.mapper)), namespaceRepository, multisigRepository, networkTypeObservable);
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Parameter '" + url + "' is not a valid URL. " + ExceptionUtils.getMessage((Throwable)e));
        }
        this.httpClient = httpClient;
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public CompletableFuture<Void> open() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.webSocket != null) {
            return CompletableFuture.completedFuture(null);
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(this.url.getHost());
        requestOptions.setPort(this.url.getPort());
        requestOptions.setURI("/ws");
        this.httpClient.websocket(requestOptions, ws -> {
            this.webSocket = ws;
            ws.handler(handler -> {
                ObjectNode message = (ObjectNode)this.getJsonHelper().convert((Object)handler.toJsonObject(), ObjectNode.class, new String[0]);
                this.handle(message, future);
            });
        });
        return future;
    }

    protected BlockInfo toBlockInfo(Object blockInfoDTO) {
        return BlockRepositoryVertxImpl.toBlockInfo((BlockInfoDTO)this.getJsonHelper().convert(blockInfoDTO, BlockInfoDTO.class, new String[0]), this.getJsonHelper());
    }

    protected FinalizedBlock toFinalizedBlock(Object blockInfoDTO) {
        return ChainRepositoryVertxImpl.toFinalizedBlock((FinalizedBlockDTO)this.getJsonHelper().convert(blockInfoDTO, FinalizedBlockDTO.class, new String[0]));
    }

    protected Transaction toTransaction(TransactionGroup group, Object transactionInfo) {
        return this.transactionMapper.mapToFactoryFromDto(transactionInfo).group(group).build();
    }

    protected CosignatureSignedTransaction toCosignatureSignedTransaction(Object cosignatureJson, NetworkType networkType) {
        Cosignature cosignature = (Cosignature)this.getJsonHelper().convert(cosignatureJson, Cosignature.class, new String[0]);
        return new CosignatureSignedTransaction(cosignature.getVersion(), cosignature.getParentHash(), cosignature.getSignature(), PublicAccount.createFromPublicKey((String)cosignature.getSignerPublicKey(), (NetworkType)networkType));
    }

    public void close() {
        if (this.webSocket != null) {
            this.setUid(null);
            this.webSocket.close();
            this.webSocket = null;
        }
    }

    protected void subscribeTo(String channel) {
        ListenerSubscribeMessage subscribeMessage = new ListenerSubscribeMessage(this.getUid(), channel);
        this.webSocket.writeTextMessage(this.getJsonHelper().print((Object)subscribeMessage));
    }
}

