/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.VrfKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.VrfKeyLinkTransactionFactory;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.VrfKeyLinkTransactionDTO;

public class VrfKeyLinkTransactionMapper
extends AbstractTransactionMapper<VrfKeyLinkTransactionDTO, VrfKeyLinkTransaction> {
    public VrfKeyLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.VRF_KEY_LINK, VrfKeyLinkTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<VrfKeyLinkTransaction> createFactory(NetworkType networkType, Deadline deadline, VrfKeyLinkTransactionDTO transaction) {
        PublicKey linkedPublicKey = PublicKey.fromHexString((String)transaction.getLinkedPublicKey());
        LinkAction linkAction = LinkAction.rawValueOf((int)transaction.getLinkAction().getValue());
        return VrfKeyLinkTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (PublicKey)linkedPublicKey, (LinkAction)linkAction);
    }

    @Override
    protected void copyToDto(VrfKeyLinkTransaction transaction, VrfKeyLinkTransactionDTO dto) {
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
        dto.setLinkedPublicKey(transaction.getLinkedPublicKey().toHex());
    }
}

