/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.NodeKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.NodeKeyLinkTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NodeKeyLinkTransactionDTO;

public class NodeKeyLinkTransactionMapper
extends AbstractTransactionMapper<NodeKeyLinkTransactionDTO, NodeKeyLinkTransaction> {
    public NodeKeyLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.NODE_KEY_LINK, NodeKeyLinkTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<NodeKeyLinkTransaction> createFactory(NetworkType networkType, Deadline deadline, NodeKeyLinkTransactionDTO transaction) {
        PublicKey linkedPublicKey = PublicKey.fromHexString((String)transaction.getLinkedPublicKey());
        LinkAction linkAction = LinkAction.rawValueOf((int)transaction.getLinkAction().getValue());
        return NodeKeyLinkTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (PublicKey)linkedPublicKey, (LinkAction)linkAction);
    }

    @Override
    protected void copyToDto(NodeKeyLinkTransaction transaction, NodeKeyLinkTransactionDTO dto) {
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
        dto.setLinkedPublicKey(transaction.getLinkedPublicKey().toHex());
    }
}

