/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.AccountRestrictionSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.RestrictionAccountRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.AccountRestriction;
import io.nem.symbol.sdk.model.account.AccountRestrictions;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionTargetType;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsPage;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.reactivex.Observable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class RestrictionAccountRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements RestrictionAccountRepository {
    private final RestrictionAccountRoutesApi client;

    public RestrictionAccountRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new RestrictionAccountRoutesApiImpl(apiClient);
    }

    public Observable<AccountRestrictions> getAccountRestrictions(Address address) {
        return this.call(handler -> this.getClient().getAccountRestrictions(address.plain(), handler), this::toAccountRestrictions);
    }

    private AccountRestrictions toAccountRestrictions(AccountRestrictionsInfoDTO dto) {
        return new AccountRestrictions(((Integer)ObjectUtils.defaultIfNull((Object)dto.getAccountRestrictions().getVersion(), (Object)1)).intValue(), MapperUtils.toAddress((String)dto.getAccountRestrictions().getAddress()), dto.getAccountRestrictions().getRestrictions().stream().map(this::toAccountRestriction).collect(Collectors.toList()));
    }

    private AccountRestriction toAccountRestriction(AccountRestrictionDTO dto) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)dto.getRestrictionFlags().getValue());
        return new AccountRestriction(restrictionFlags, dto.getValues().stream().filter(Objects::nonNull).map(Object::toString).map(arg_0 -> ((AccountRestrictionTargetType)restrictionFlags.getTargetType()).fromString(arg_0)).collect(Collectors.toList()));
    }

    public Observable<MerkleStateInfo> getAccountRestrictionsMerkle(Address address) {
        return this.call(h -> this.getClient().getAccountRestrictionsMerkle(address.plain(), h), this::toMerkleStateInfo);
    }

    public RestrictionAccountRoutesApi getClient() {
        return this.client;
    }

    public Observable<Page<AccountRestrictions>> search(AccountRestrictionSearchCriteria criteria) {
        String address = this.toDto(criteria.getAddress());
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer handlerConsumer = h -> this.getClient().searchAccountRestrictions(address, pageSize, pageNumber, offset, order, h);
        return this.call(handlerConsumer, this::toPage);
    }

    private Page<AccountRestrictions> toPage(AccountRestrictionsPage page) {
        return this.toPage(page.getPagination(), page.getData().stream().map(this::toAccountRestrictions).collect(Collectors.toList()));
    }
}

