/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.NamespaceSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.AccountNames;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicNames;
import io.nem.symbol.sdk.model.namespace.AddressAlias;
import io.nem.symbol.sdk.model.namespace.Alias;
import io.nem.symbol.sdk.model.namespace.AliasType;
import io.nem.symbol.sdk.model.namespace.EmptyAlias;
import io.nem.symbol.sdk.model.namespace.MosaicAlias;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceInfo;
import io.nem.symbol.sdk.model.namespace.NamespaceName;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Addresses;
import io.nem.symbol.sdk.openapi.vertx.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class NamespaceRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NamespaceRepository {
    private final NamespaceRoutesApi client;

    public NamespaceRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new NamespaceRoutesApiImpl(apiClient);
    }

    public NamespaceRoutesApi getClient() {
        return this.client;
    }

    public Observable<NamespaceInfo> getNamespace(NamespaceId namespaceId) {
        return this.call(h -> this.getClient().getNamespace(namespaceId.getIdAsHex(), h), this::toNamespaceInfo);
    }

    public Observable<MerkleStateInfo> getNamespaceMerkle(NamespaceId namespaceId) {
        return this.call(h -> this.getClient().getNamespaceMerkle(namespaceId.getIdAsHex(), h), this::toMerkleStateInfo);
    }

    public Observable<Page<NamespaceInfo>> search(NamespaceSearchCriteria criteria) {
        String ownerAddress = this.toDto(criteria.getOwnerAddress());
        NamespaceRegistrationTypeEnum registrationType = criteria.getRegistrationType() == null ? null : NamespaceRegistrationTypeEnum.fromValue((Integer)criteria.getRegistrationType().getValue());
        String level0 = criteria.getLevel0();
        AliasTypeEnum aliasType = criteria.getAliasType() == null ? null : AliasTypeEnum.fromValue((Integer)criteria.getAliasType().getValue());
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = handler -> this.getClient().searchNamespaces(ownerAddress, registrationType, level0, aliasType, pageSize, pageNumber, offset, order, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this::toNamespaceInfo).collect(Collectors.toList()))));
    }

    public Observable<List<NamespaceName>> getNamespaceNames(List<NamespaceId> namespaceIds) {
        NamespaceIds ids = new NamespaceIds().namespaceIds(namespaceIds.stream().map(NamespaceId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.client.getNamespacesNames(ids, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceName).toList().toObservable());
    }

    public Observable<List<MosaicNames>> getMosaicsNames(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getMosaicsNames(mosaicIds, handler);
        return this.exceptionHandling(this.call(callback).map(MosaicsNamesDTO::getMosaicNames).flatMapIterable(item -> item).map(this::toMosaicNames).toList().toObservable());
    }

    private MosaicNames toMosaicNames(MosaicNamesDTO dto) {
        return new MosaicNames(MapperUtils.toMosaicId((String)dto.getMosaicId()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    public Observable<MosaicId> getLinkedMosaicId(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toMosaicId(namespaceInfoDTO.getNamespace())));
    }

    public Observable<Address> getLinkedAddress(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toAddress(namespaceInfoDTO.getNamespace())));
    }

    private NamespaceName toNamespaceName(NamespaceNameDTO dto) {
        return new NamespaceName(MapperUtils.toNamespaceId((String)dto.getId()), dto.getName(), Optional.ofNullable(MapperUtils.toNamespaceId((String)dto.getParentId())));
    }

    private NamespaceInfo toNamespaceInfo(NamespaceInfoDTO namespaceInfoDTO) {
        return new NamespaceInfo(namespaceInfoDTO.getId(), ((Integer)ObjectUtils.defaultIfNull((Object)namespaceInfoDTO.getNamespace().getVersion(), (Object)1)).intValue(), namespaceInfoDTO.getMeta().getActive().booleanValue(), namespaceInfoDTO.getMeta().getIndex(), NamespaceRegistrationType.rawValueOf((int)namespaceInfoDTO.getNamespace().getRegistrationType().getValue()), namespaceInfoDTO.getNamespace().getDepth(), this.extractLevels(namespaceInfoDTO), MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getParentId()), MapperUtils.toAddress((String)namespaceInfoDTO.getNamespace().getOwnerAddress()), namespaceInfoDTO.getNamespace().getStartHeight(), namespaceInfoDTO.getNamespace().getEndHeight(), this.extractAlias(namespaceInfoDTO.getNamespace()));
    }

    private MosaicId toMosaicId(NamespaceDTO namespaceDTO) {
        MosaicId mosaicId = null;
        if (namespaceDTO.getAlias() != null && AliasType.MOSAIC.getValue() == namespaceDTO.getAlias().getType().getValue().intValue()) {
            mosaicId = MapperUtils.toMosaicId((String)namespaceDTO.getAlias().getMosaicId());
        }
        return mosaicId;
    }

    private Address toAddress(NamespaceDTO namespaceDTO) {
        String encodedAddress;
        Address address = null;
        if (namespaceDTO.getAlias() != null && AliasType.ADDRESS.getValue() == namespaceDTO.getAlias().getType().getValue().intValue() && (encodedAddress = namespaceDTO.getAlias().getAddress()) != null) {
            address = MapperUtils.toAddress((String)encodedAddress);
        }
        return address;
    }

    public Observable<List<AccountNames>> getAccountsNames(List<Address> addresses) {
        Addresses accountIds = new Addresses().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountsNames(accountIds);
    }

    private Observable<List<AccountNames>> getAccountsNames(Addresses accountIds) {
        Consumer callback = handler -> this.getClient().getAccountsNames(accountIds, handler);
        return this.exceptionHandling(this.call(callback).map(AccountsNamesDTO::getAccountNames).flatMapIterable(item -> item).map(this::toAccountNames).toList().toObservable());
    }

    private AccountNames toAccountNames(AccountNamesDTO dto) {
        return new AccountNames(MapperUtils.toAddress((String)dto.getAddress()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    private List<NamespaceId> extractLevels(NamespaceInfoDTO namespaceInfoDTO) {
        ArrayList<NamespaceId> levels = new ArrayList<NamespaceId>();
        if (namespaceInfoDTO.getNamespace().getLevel0() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel0()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel1() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel1()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel2() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel2()));
        }
        return levels;
    }

    private Alias<?> extractAlias(NamespaceDTO namespaceDTO) {
        if (namespaceDTO.getAlias() != null) {
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.MOSAIC.getValue())) {
                return new MosaicAlias(this.toMosaicId(namespaceDTO));
            }
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.ADDRESS.getValue())) {
                return new AddressAlias(this.toAddress(namespaceDTO));
            }
        }
        return new EmptyAlias();
    }
}

