/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.OrderBy;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.RepositoryCallException;
import io.nem.symbol.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.symbol.sdk.infrastructure.vertx.MerkleMapper;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.Pagination;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractRepositoryVertxImpl {
    private final JsonHelper jsonHelper;

    public AbstractRepositoryVertxImpl(ApiClient apiClient) {
        this.jsonHelper = new JsonHelperJackson2(apiClient.getObjectMapper());
    }

    public <T> Observable<T> call(Consumer<Handler<AsyncResult<T>>> callback) {
        IllegalArgumentException originalException = new IllegalArgumentException("Original call");
        Function<Throwable, Observable<T>> resumeFunction = this.onError(originalException);
        return new AsyncResultSingle(callback::accept).toObservable().onErrorResumeNext(resumeFunction);
    }

    public <T, R> Observable<R> call(Consumer<Handler<AsyncResult<T>>> callback, Function<? super T, ? extends R> mapper) {
        return this.exceptionHandling(this.call(callback).map(mapper));
    }

    public <T, R> Observable<List<R>> callList(Consumer<Handler<AsyncResult<List<T>>>> callback, java.util.function.Function<T, R> mapper) {
        return this.exceptionHandling(this.call(callback).map(l -> l.stream().map(mapper).collect(Collectors.toList())));
    }

    public RepositoryCallException exceptionHandling(Throwable e, IllegalArgumentException originalException) {
        if (e instanceof RepositoryCallException) {
            return (RepositoryCallException)e;
        }
        return new RepositoryCallException(this.extractMessageFromException(e), this.extractStatusCodeFromException(e), e instanceof ApiException ? originalException : e);
    }

    private String extractMessageFromException(Throwable e) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(ExceptionUtils.getMessage((Throwable)e));
        if (e instanceof ApiException) {
            messages.add("" + ((ApiException)e).getCode());
            String responseBody = ((ApiException)e).getResponseBody();
            if (responseBody != null) {
                try {
                    Object json = this.jsonHelper.parse(responseBody);
                    messages.add(this.jsonHelper.getString(json, new String[]{"code"}));
                    messages.add(this.jsonHelper.getString(json, new String[]{"message"}));
                }
                catch (IllegalArgumentException ignore) {
                    messages.add(StringUtils.truncate((String)responseBody, (int)100));
                }
            }
        }
        return messages.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" - "));
    }

    private int extractStatusCodeFromException(Throwable e) {
        return e instanceof ApiException ? ((ApiException)e).getCode() : 0;
    }

    public <T> Function<Throwable, Observable<T>> onError(IllegalArgumentException originalException) {
        return e -> Observable.error((Throwable)this.exceptionHandling((Throwable)e, originalException));
    }

    public <T> Observable<T> exceptionHandling(Observable<T> observable) {
        IllegalArgumentException originalException = new IllegalArgumentException("Original call");
        Function<Throwable, Observable<T>> resumeFunction = this.onError(originalException);
        return observable.onErrorResumeNext(resumeFunction);
    }

    protected Order toDto(OrderBy order) {
        return order == null ? null : Order.fromValue((String)order.getValue());
    }

    protected String toDto(PublicKey publicKey) {
        return publicKey == null ? null : publicKey.toHex();
    }

    protected String toDto(Address address) {
        return address == null ? null : address.plain();
    }

    protected String toDto(MosaicId mosaicId) {
        return mosaicId == null ? null : mosaicId.getIdAsHex();
    }

    protected String toDto(BigInteger number) {
        if (number == null) {
            return null;
        }
        ConvertUtils.validateNotNegative((BigInteger)number);
        return MapperUtils.fromBigIntegerToHex((BigInteger)number);
    }

    protected <T> Page<T> toPage(Pagination pagination, List<T> data) {
        return new Page(data, pagination.getPageNumber(), pagination.getPageSize());
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    protected MerkleStateInfo toMerkleStateInfo(MerkleStateInfoDTO dto) {
        return new MerkleMapper(this.getJsonHelper()).toMerkleStateInfo(dto);
    }
}

