/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.TransferTransaction;
import io.nem.symbol.sdk.model.transaction.TransferTransactionFactory;
import io.nem.symbol.sdk.openapi.vertx.model.TransferTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.UnresolvedMosaic;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class TransferTransactionMapper
extends AbstractTransactionMapper<TransferTransactionDTO, TransferTransaction> {
    public TransferTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.TRANSFER, TransferTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<TransferTransaction> createFactory(NetworkType networkType, Deadline deadline, TransferTransactionDTO transaction) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map(mosaic -> new Mosaic(MapperUtils.toUnresolvedMosaicId((String)mosaic.getId()), mosaic.getAmount())).collect(Collectors.toList());
        }
        TransferTransactionFactory transferTransactionFactory = TransferTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()), mosaics);
        Message.createFromHexPayload((String)transaction.getMessage()).ifPresent(arg_0 -> ((TransferTransactionFactory)transferTransactionFactory).message(arg_0));
        return transferTransactionFactory;
    }

    @Override
    protected void copyToDto(TransferTransaction transaction, TransferTransactionDTO dto) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map(mosaic -> {
                UnresolvedMosaic mosaicDto = new UnresolvedMosaic();
                mosaicDto.setAmount(mosaic.getAmount());
                mosaicDto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)mosaic.getId()));
                return mosaicDto;
            }).collect(Collectors.toList());
        }
        String message = transaction.getMessage().map(Message::getPayloadHex).orElse(null);
        dto.setRecipientAddress(transaction.getRecipient().encoded(transaction.getNetworkType()));
        dto.setMosaics(mosaics);
        dto.setMessage(message);
    }
}

