/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.TransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AccountAddressRestrictionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AccountKeyLinkTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AccountMetadataTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AccountMosaicRestrictionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AccountOperationRestrictionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AddressAliasTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AggregateTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.HashLockTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicAddressRestrictionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicAliasTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicDefinitionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicGlobalRestrictionTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicMetadataTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MosaicSupplyChangeTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.MultisigAccountModificationTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.NamespaceMetadataTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.NamespaceRegistrationTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.NodeKeyLinkTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.SecretLockTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.SecretProofTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.TransferTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.VotingKeyLinkTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.VrfKeyLinkTransactionMapper;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GeneralTransactionMapper
implements TransactionMapper {
    private final JsonHelper jsonHelper;
    private final Map<Pair<TransactionType, Integer>, TransactionMapper> transactionMappers = new HashMap<Pair<TransactionType, Integer>, TransactionMapper>();

    public GeneralTransactionMapper(JsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
        Validate.notNull((Object)jsonHelper, (String)"jsonHelper must not be null", (Object[])new Object[0]);
        this.register(new AddressAliasTransactionMapper(jsonHelper));
        this.register(new HashLockTransactionMapper(jsonHelper));
        this.register(new MosaicAddressRestrictionTransactionMapper(jsonHelper));
        this.register(new MosaicAliasTransactionMapper(jsonHelper));
        this.register(new MosaicDefinitionTransactionMapper(jsonHelper));
        this.register(new MosaicGlobalRestrictionTransactionMapper(jsonHelper));
        this.register(new MosaicSupplyChangeTransactionMapper(jsonHelper));
        this.register(new MultisigAccountModificationTransactionMapper(jsonHelper));
        this.register(new NamespaceRegistrationTransactionMapper(jsonHelper));
        this.register(new SecretLockTransactionMapper(jsonHelper));
        this.register(new SecretProofTransactionMapper(jsonHelper));
        this.register(new TransferTransactionMapper(jsonHelper));
        this.register(new AccountMetadataTransactionMapper(jsonHelper));
        this.register(new MosaicMetadataTransactionMapper(jsonHelper));
        this.register(new NamespaceMetadataTransactionMapper(jsonHelper));
        this.register(new AccountAddressRestrictionTransactionMapper(jsonHelper));
        this.register(new AccountMosaicRestrictionTransactionMapper(jsonHelper));
        this.register(new AccountOperationRestrictionTransactionMapper(jsonHelper));
        this.register(new NodeKeyLinkTransactionMapper(jsonHelper));
        this.register(new VotingKeyLinkTransactionMapper(jsonHelper));
        this.register(new VrfKeyLinkTransactionMapper(jsonHelper));
        this.register(new AccountKeyLinkTransactionMapper(jsonHelper));
        this.register(new AggregateTransactionMapper(jsonHelper, TransactionType.AGGREGATE_BONDED, this));
        this.register(new AggregateTransactionMapper(jsonHelper, TransactionType.AGGREGATE_COMPLETE, this));
    }

    private void register(TransactionMapper mapper) {
        if (this.transactionMappers.put((Pair<TransactionType, Integer>)Pair.of((Object)mapper.getTransactionType(), (Object)mapper.getVersion()), mapper) != null) {
            throw new IllegalArgumentException("TransactionMapper for type " + mapper.getTransactionType() + " version " + mapper.getVersion() + " was already registered!");
        }
    }

    public TransactionFactory<?> mapToFactoryFromDto(Object transactionInfoDTO) {
        try {
            Validate.notNull((Object)transactionInfoDTO, (String)"transactionInfoDTO must not be null", (Object[])new Object[0]);
            return this.resolveMapper(transactionInfoDTO).mapToFactoryFromDto(transactionInfoDTO);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown error mapping transaction: " + ExceptionUtils.getMessage((Throwable)e) + "\n" + this.jsonHelper.prettyPrint(transactionInfoDTO), e);
        }
    }

    public Transaction mapFromDto(Object transactionInfoDTO) {
        return this.mapToFactoryFromDto(transactionInfoDTO).build();
    }

    public Object mapToDto(Transaction transaction, Boolean embedded) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        return this.resolveMapper(transaction.getType(), transaction.getVersion()).mapToDto(transaction, embedded);
    }

    public TransactionType getTransactionType() {
        return null;
    }

    private TransactionMapper resolveMapper(Object transactionInfoJson) {
        Integer type = this.getJsonHelper().getInteger(transactionInfoJson, new String[]{"transaction", "type"});
        if (type == null) {
            throw new IllegalArgumentException("Transaction cannot be mapped, object does not not have transaction type.");
        }
        Integer version = this.getJsonHelper().getInteger(transactionInfoJson, new String[]{"transaction", "version"});
        if (version == null) {
            throw new IllegalArgumentException("Transaction cannot be mapped, object does not not have transaction version.");
        }
        TransactionType transactionType = TransactionType.rawValueOf((int)type);
        return this.resolveMapper(transactionType, version);
    }

    private TransactionMapper resolveMapper(TransactionType transactionType, int version) {
        TransactionMapper mapper = this.transactionMappers.get(Pair.of((Object)transactionType, (Object)version));
        if (mapper == null) {
            throw new UnsupportedOperationException("Unimplemented Transaction type " + transactionType + " version " + version);
        }
        return mapper;
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }
}

