/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.ReceiptRepository;
import io.nem.symbol.sdk.api.ResolutionStatementSearchCriteria;
import io.nem.symbol.sdk.api.TransactionStatementSearchCriteria;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.ReceiptMappingVertx;
import io.nem.symbol.sdk.model.receipt.AddressResolutionStatement;
import io.nem.symbol.sdk.model.receipt.MosaicResolutionStatement;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.TransactionStatement;
import io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.ReceiptTypeEnum;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ReceiptRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ReceiptRepository {
    private final ReceiptRoutesApi client;
    private final ReceiptMappingVertx mapper;

    public ReceiptRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new ReceiptRoutesApiImpl(apiClient);
        this.mapper = new ReceiptMappingVertx(this.getJsonHelper());
    }

    public Observable<Page<TransactionStatement>> searchReceipts(TransactionStatementSearchCriteria criteria) {
        BigInteger height = criteria.getHeight();
        List<ReceiptTypeEnum> receiptTypes = this.toDto(criteria.getReceiptTypes());
        String recipientAddress = this.toDto(criteria.getRecipientAddress());
        String senderAddress = this.toDto(criteria.getSenderAddress());
        String targetAddress = this.toDto(criteria.getTargetAddress());
        String artifactId = criteria.getArtifactId();
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = handler -> this.getClient().searchReceipts(height, receiptTypes, recipientAddress, senderAddress, targetAddress, artifactId, pageSize, pageNumber, offset, order, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this.mapper::createTransactionStatement).collect(Collectors.toList()))));
    }

    public Observable<Page<AddressResolutionStatement>> searchAddressResolutionStatements(ResolutionStatementSearchCriteria criteria) {
        BigInteger height = criteria.getHeight();
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = handler -> this.getClient().searchAddressResolutionStatements(height, pageSize, pageNumber, offset, order, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this.mapper::createAddressResolutionStatementFromDto).collect(Collectors.toList()))));
    }

    public Observable<Page<MosaicResolutionStatement>> searchMosaicResolutionStatements(ResolutionStatementSearchCriteria criteria) {
        BigInteger height = criteria.getHeight();
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = handler -> this.getClient().searchMosaicResolutionStatements(height, pageSize, pageNumber, offset, order, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this.mapper::createMosaicResolutionStatementFromDto).collect(Collectors.toList()))));
    }

    private List<ReceiptTypeEnum> toDto(List<ReceiptType> values) {
        return values == null ? null : values.stream().map(e -> ReceiptTypeEnum.fromValue((Integer)e.getValue())).collect(Collectors.toList());
    }

    public ReceiptRoutesApi getClient() {
        return this.client;
    }
}

