/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.VotingKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.VotingKeyLinkV1Transaction;
import io.nem.symbol.sdk.model.transaction.VotingKeyLinkV1TransactionFactory;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.VotingKeyLinkTransactionDTO;

public class VotingKeyLinkV1TransactionMapper
extends AbstractTransactionMapper<VotingKeyLinkTransactionDTO, VotingKeyLinkV1Transaction> {
    public VotingKeyLinkV1TransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.VOTING_KEY_LINK, VotingKeyLinkTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<VotingKeyLinkV1Transaction> createFactory(NetworkType networkType, Deadline deadline, VotingKeyLinkTransactionDTO transaction) {
        VotingKey linkedPublicKey = VotingKey.fromHexString((String)transaction.getLinkedPublicKey());
        LinkAction linkAction = LinkAction.rawValueOf((int)transaction.getLinkAction().getValue());
        return VotingKeyLinkV1TransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (VotingKey)linkedPublicKey, (long)transaction.getStartEpoch(), (long)transaction.getEndEpoch(), (LinkAction)linkAction);
    }

    public int getVersion() {
        return 1;
    }

    @Override
    protected void copyToDto(VotingKeyLinkV1Transaction transaction, VotingKeyLinkTransactionDTO dto) {
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
        dto.setLinkedPublicKey(transaction.getLinkedPublicKey().toHex());
        dto.setStartEpoch(Long.valueOf(transaction.getStartEpoch()));
        dto.setEndEpoch(Long.valueOf(transaction.getEndEpoch()));
    }
}

