/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountModificationTransactionDTO;
import java.util.List;
import java.util.stream.Collectors;

class MultisigAccountModificationTransactionMapper
extends AbstractTransactionMapper<MultisigAccountModificationTransactionDTO, MultisigAccountModificationTransaction> {
    public MultisigAccountModificationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MULTISIG_ACCOUNT_MODIFICATION, MultisigAccountModificationTransactionDTO.class);
    }

    protected MultisigAccountModificationTransactionFactory createFactory(NetworkType networkType, Deadline deadline, MultisigAccountModificationTransactionDTO transaction) {
        List additions = transaction.getAddressAdditions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        List deletions = transaction.getAddressDeletions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        return MultisigAccountModificationTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (byte)transaction.getMinApprovalDelta().byteValue(), (byte)transaction.getMinRemovalDelta().byteValue(), additions, deletions);
    }

    @Override
    protected void copyToDto(MultisigAccountModificationTransaction transaction, MultisigAccountModificationTransactionDTO dto) {
        dto.setMinApprovalDelta(Integer.valueOf(transaction.getMinApprovalDelta()));
        dto.setMinRemovalDelta(Integer.valueOf(transaction.getMinRemovalDelta()));
        dto.setAddressAdditions(transaction.getAddressAdditions().stream().map(p -> p.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
        dto.setAddressDeletions(transaction.getAddressDeletions().stream().map(p -> p.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
    }
}

