/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicMetadataTransactionDTO;
import java.math.BigInteger;

class MosaicMetadataTransactionMapper
extends AbstractTransactionMapper<MosaicMetadataTransactionDTO, MosaicMetadataTransaction> {
    public MosaicMetadataTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_METADATA, MosaicMetadataTransactionDTO.class);
    }

    protected MosaicMetadataTransactionFactory createFactory(NetworkType networkType, Deadline deadline, MosaicMetadataTransactionDTO transaction) {
        UnresolvedAddress targetAddress = MapperUtils.toUnresolvedAddress((String)transaction.getTargetAddress());
        Integer valueSizeDelta = transaction.getValueSizeDelta();
        BigInteger scopedMetaDataKey = MapperUtils.fromHexToBigInteger((String)transaction.getScopedMetadataKey());
        String value = ConvertUtils.fromHexToString((String)transaction.getValue());
        UnresolvedMosaicId targetMosaic = MapperUtils.toUnresolvedMosaicId((String)transaction.getTargetMosaicId());
        MosaicMetadataTransactionFactory factory = MosaicMetadataTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (UnresolvedAddress)targetAddress, (UnresolvedMosaicId)targetMosaic, (BigInteger)scopedMetaDataKey, (String)value);
        factory.valueSizeDelta(valueSizeDelta.intValue());
        Long valueSize = transaction.getValueSize();
        if (valueSize != null) {
            factory.valueSize(valueSize.longValue());
        }
        return factory;
    }

    @Override
    protected void copyToDto(MosaicMetadataTransaction transaction, MosaicMetadataTransactionDTO dto) {
        dto.setTargetAddress(transaction.getTargetAddress().encoded(transaction.getNetworkType()));
        dto.setTargetMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getTargetMosaicId()));
        dto.setScopedMetadataKey(MapperUtils.fromBigIntegerToHex((BigInteger)transaction.getScopedMetadataKey()));
        dto.setValue(ConvertUtils.fromStringToHex((String)transaction.getValue()));
        dto.setValueSizeDelta(Integer.valueOf(transaction.getValueSizeDelta()));
        dto.setValueSize(Long.valueOf(transaction.getValueSize()));
    }
}

