/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.FinalizationRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.finalization.BmTreeSignature;
import io.nem.symbol.sdk.model.finalization.FinalizationProof;
import io.nem.symbol.sdk.model.finalization.FinalizationStage;
import io.nem.symbol.sdk.model.finalization.MessageGroup;
import io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.FinalizationProofDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ParentPublicKeySignaturePair;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class FinalizationRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements FinalizationRepository {
    private final FinalizationRoutesApi client;

    public FinalizationRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new FinalizationRoutesApiImpl(apiClient);
    }

    public Observable<FinalizationProof> getFinalizationProofAtEpoch(long epoch) {
        return this.call(h -> this.getClient().getFinalizationProofAtEpoch(Long.valueOf(epoch), h), this::toFinalizationProof);
    }

    public Observable<FinalizationProof> getFinalizationProofAtHeight(BigInteger height) {
        return this.call(h -> this.getClient().getFinalizationProofAtHeight(height, h), this::toFinalizationProof);
    }

    private FinalizationProof toFinalizationProof(FinalizationProofDTO dto) {
        List messageGroups = dto.getMessageGroups().stream().map(this::toMessageGroup).collect(Collectors.toList());
        return new FinalizationProof(dto.getVersion().intValue(), dto.getFinalizationEpoch().longValue(), dto.getFinalizationPoint().longValue(), dto.getHeight(), dto.getHash(), messageGroups);
    }

    private MessageGroup toMessageGroup(io.nem.symbol.sdk.openapi.vertx.model.MessageGroup dto) {
        return new MessageGroup(dto.getSignatureSchema(), FinalizationStage.rawValueOf((int)dto.getStage().getValue()), dto.getHeight(), dto.getHashes(), dto.getSignatures().stream().map(this::toBmTreeSignature).collect(Collectors.toList()));
    }

    private BmTreeSignature toBmTreeSignature(io.nem.symbol.sdk.openapi.vertx.model.BmTreeSignature dto) {
        return new BmTreeSignature(this.toParentPublicKeySignaturePair(dto.getRoot()), this.toParentPublicKeySignaturePair(dto.getBottom()));
    }

    private io.nem.symbol.sdk.model.finalization.ParentPublicKeySignaturePair toParentPublicKeySignaturePair(ParentPublicKeySignaturePair dto) {
        return new io.nem.symbol.sdk.model.finalization.ParentPublicKeySignaturePair(dto.getParentPublicKey(), dto.getSignature());
    }

    public FinalizationRoutesApi getClient() {
        return this.client;
    }
}

