/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.ChainRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.ChainInfo;
import io.nem.symbol.sdk.model.blockchain.FinalizedBlock;
import io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.ChainInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.FinalizedBlockDTO;
import io.reactivex.Observable;

public class ChainRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ChainRepository {
    private final ChainRoutesApi client;

    public ChainRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new ChainRoutesApiImpl(apiClient);
    }

    public ChainRoutesApi getClient() {
        return this.client;
    }

    public Observable<ChainInfo> getChainInfo() {
        return this.call(arg_0 -> ((ChainRoutesApi)this.getClient()).getChainInfo(arg_0), this::toChainInfo);
    }

    private ChainInfo toChainInfo(ChainInfoDTO dto) {
        return new ChainInfo(dto.getHeight(), dto.getScoreLow(), dto.getScoreHigh(), ChainRepositoryVertxImpl.toFinalizedBlock(dto.getLatestFinalizedBlock()));
    }

    public static FinalizedBlock toFinalizedBlock(FinalizedBlockDTO dto) {
        return new FinalizedBlock(dto.getFinalizationEpoch(), dto.getFinalizationPoint(), dto.getHeight(), dto.getHash());
    }
}

