/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.BlockOrderBy;
import io.nem.symbol.sdk.api.BlockRepository;
import io.nem.symbol.sdk.api.BlockSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.BlockType;
import io.nem.symbol.sdk.model.blockchain.ImportanceBlockInfo;
import io.nem.symbol.sdk.model.blockchain.MerklePathItem;
import io.nem.symbol.sdk.model.blockchain.MerkleProofInfo;
import io.nem.symbol.sdk.model.blockchain.Position;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ImportanceBlockDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BlockRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements BlockRepository {
    private final BlockRoutesApi client;

    public BlockRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new BlockRoutesApiImpl(apiClient);
    }

    public Observable<BlockInfo> getBlockByHeight(BigInteger height) {
        Consumer callback = handler -> this.getClient().getBlockByHeight(height, handler);
        return this.exceptionHandling(this.call(callback).map(blockInfoDTO -> BlockRepositoryVertxImpl.toBlockInfo(blockInfoDTO, this.getJsonHelper())));
    }

    public Observable<Page<BlockInfo>> search(BlockSearchCriteria criteria) {
        Consumer callback = handler -> this.getClient().searchBlocks(this.toDto(criteria.getSignerPublicKey()), this.toDto(criteria.getBeneficiaryAddress()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), this.toDto(criteria.getOrderBy()), handler);
        return this.exceptionHandling(this.call(callback).map(mosaicPage -> this.toPage(mosaicPage.getPagination(), mosaicPage.getData().stream().map(blockInfoDTO -> BlockRepositoryVertxImpl.toBlockInfo(blockInfoDTO, this.getJsonHelper())).collect(Collectors.toList()))));
    }

    private BlockOrderByEnum toDto(BlockOrderBy orderBy) {
        return orderBy == null ? null : BlockOrderByEnum.fromValue((String)orderBy.getValue());
    }

    public Observable<MerkleProofInfo> getMerkleTransaction(BigInteger height, String hash) {
        Consumer callback = handler -> this.client.getMerkleTransaction(height, hash, handler);
        return this.call(callback, this::toMerkleProofInfo);
    }

    private MerkleProofInfo toMerkleProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerklePathItem(pathItem.getPosition() == null ? null : Position.rawValueOf((String)pathItem.getPosition().getValue()), pathItem.getHash())).collect(Collectors.toList());
        return new MerkleProofInfo(pathItems);
    }

    public Observable<MerkleProofInfo> getMerkleReceipts(BigInteger height, String hash) {
        Consumer callback = handler -> this.getClient().getMerkleReceipts(height, hash, handler);
        return this.call(callback, this::toMerkleProofInfo);
    }

    public static BlockInfo toBlockInfo(BlockInfoDTO blockInfoDTO, JsonHelper jsonHelper) {
        ImportanceBlockDTO block = (ImportanceBlockDTO)jsonHelper.convert(blockInfoDTO.getBlock(), ImportanceBlockDTO.class, new String[0]);
        NetworkType networkType = NetworkType.rawValueOf((int)block.getNetwork().getValue());
        BlockType type = BlockType.rawValueOf((int)block.getType());
        if (type == BlockType.NORMAL_BLOCK || block.getVotingEligibleAccountsCount() == null) {
            return new BlockInfo(blockInfoDTO.getId(), block.getSize(), blockInfoDTO.getMeta().getHash(), blockInfoDTO.getMeta().getGenerationHash(), blockInfoDTO.getMeta().getTotalFee(), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), blockInfoDTO.getMeta().getTransactionsCount(), blockInfoDTO.getMeta().getTotalTransactionsCount(), blockInfoDTO.getMeta().getStatementsCount(), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), block.getSignature(), PublicAccount.createFromPublicKey((String)block.getSignerPublicKey(), (NetworkType)networkType), networkType, block.getVersion(), type, block.getHeight(), block.getTimestamp(), block.getDifficulty(), block.getFeeMultiplier(), block.getPreviousBlockHash(), block.getTransactionsHash(), block.getReceiptsHash(), block.getStateHash(), block.getProofGamma(), block.getProofScalar(), block.getProofVerificationHash(), MapperUtils.toAddress((String)block.getBeneficiaryAddress()));
        }
        return new ImportanceBlockInfo(blockInfoDTO.getId(), block.getSize(), blockInfoDTO.getMeta().getHash(), blockInfoDTO.getMeta().getGenerationHash(), blockInfoDTO.getMeta().getTotalFee(), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), blockInfoDTO.getMeta().getTransactionsCount(), blockInfoDTO.getMeta().getTotalTransactionsCount(), blockInfoDTO.getMeta().getStatementsCount(), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), block.getSignature(), PublicAccount.createFromPublicKey((String)block.getSignerPublicKey(), (NetworkType)networkType), networkType, block.getVersion(), type, block.getHeight(), block.getTimestamp(), block.getDifficulty(), block.getFeeMultiplier(), block.getPreviousBlockHash(), block.getTransactionsHash(), block.getReceiptsHash(), block.getStateHash(), block.getProofGamma(), block.getProofScalar(), block.getProofVerificationHash(), MapperUtils.toAddress((String)block.getBeneficiaryAddress()), block.getVotingEligibleAccountsCount().longValue(), block.getHarvestingEligibleAccountsCount(), block.getTotalVotingBalance(), block.getPreviousImportanceBlockHash());
    }

    public BlockRoutesApi getClient() {
        return this.client;
    }
}

