/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.NamespaceMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.NamespaceMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceMetadataTransactionDTO;
import java.math.BigInteger;

class NamespaceMetadataTransactionMapper
extends AbstractTransactionMapper<NamespaceMetadataTransactionDTO, NamespaceMetadataTransaction> {
    public NamespaceMetadataTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.NAMESPACE_METADATA, NamespaceMetadataTransactionDTO.class);
    }

    protected NamespaceMetadataTransactionFactory createFactory(NetworkType networkType, NamespaceMetadataTransactionDTO transaction) {
        UnresolvedAddress targetAddress = MapperUtils.toUnresolvedAddress((String)transaction.getTargetAddress());
        Integer valueSizeDelta = transaction.getValueSizeDelta();
        BigInteger scopedMetaDataKey = MapperUtils.fromHexToBigInteger((String)transaction.getScopedMetadataKey());
        String value = ConvertUtils.fromHexToString((String)transaction.getValue());
        NamespaceId targetNamespace = MapperUtils.toNamespaceId((String)transaction.getTargetNamespaceId());
        NamespaceMetadataTransactionFactory factory = NamespaceMetadataTransactionFactory.create((NetworkType)networkType, (UnresolvedAddress)targetAddress, (NamespaceId)targetNamespace, (BigInteger)scopedMetaDataKey, (String)value);
        factory.valueSizeDelta(valueSizeDelta.intValue());
        Long valueSize = transaction.getValueSize();
        if (valueSize != null) {
            factory.valueSize(valueSize.longValue());
        }
        return factory;
    }

    @Override
    protected void copyToDto(NamespaceMetadataTransaction transaction, NamespaceMetadataTransactionDTO dto) {
        dto.setTargetAddress(transaction.getTargetAddress().encoded(transaction.getNetworkType()));
        dto.setTargetNamespaceId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getTargetNamespaceId()));
        dto.setScopedMetadataKey(MapperUtils.fromBigIntegerToHex((BigInteger)transaction.getScopedMetadataKey()));
        dto.setValue(ConvertUtils.fromStringToHex((String)transaction.getValue()));
        dto.setValueSizeDelta(Integer.valueOf(transaction.getValueSizeDelta()));
        dto.setValueSize(Long.valueOf(transaction.getValueSize()));
    }
}

