/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountOperationRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountOperationRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.AccountOperationRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountOperationRestrictionTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountOperationRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountOperationRestrictionTransactionDTO, AccountOperationRestrictionTransaction> {
    public AccountOperationRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_OPERATION_RESTRICTION, AccountOperationRestrictionTransactionDTO.class);
    }

    protected AccountOperationRestrictionTransactionFactory createFactory(NetworkType networkType, AccountOperationRestrictionTransactionDTO transaction) {
        AccountOperationRestrictionFlags restrictionFlags = AccountOperationRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List additions = transaction.getRestrictionAdditions().stream().map(transactionTypeEnum -> TransactionType.rawValueOf((int)transactionTypeEnum.getValue())).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(transactionTypeEnum -> TransactionType.rawValueOf((int)transactionTypeEnum.getValue())).collect(Collectors.toList());
        return AccountOperationRestrictionTransactionFactory.create((NetworkType)networkType, (AccountOperationRestrictionFlags)restrictionFlags, additions, deletions);
    }

    @Override
    protected void copyToDto(AccountOperationRestrictionTransaction transaction, AccountOperationRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        List additions = transaction.getRestrictionAdditions().stream().map(transactionType -> TransactionTypeEnum.fromValue((Integer)transactionType.getValue())).collect(Collectors.toList());
        List deletions = transaction.getRestrictionDeletions().stream().map(transactionType -> TransactionTypeEnum.fromValue((Integer)transactionType.getValue())).collect(Collectors.toList());
        dto.setRestrictionAdditions(additions);
        dto.setRestrictionDeletions(deletions);
    }
}

