/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.AccountMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountMetadataTransactionDTO;
import java.math.BigInteger;

class AccountMetadataTransactionMapper
extends AbstractTransactionMapper<AccountMetadataTransactionDTO, AccountMetadataTransaction> {
    public AccountMetadataTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_METADATA, AccountMetadataTransactionDTO.class);
    }

    protected AccountMetadataTransactionFactory createFactory(NetworkType networkType, AccountMetadataTransactionDTO transaction) {
        UnresolvedAddress targetAddress = MapperUtils.toUnresolvedAddress((String)transaction.getTargetAddress());
        Integer valueSizeDelta = transaction.getValueSizeDelta();
        BigInteger scopedMetaDataKey = MapperUtils.fromHexToBigInteger((String)transaction.getScopedMetadataKey());
        String value = ConvertUtils.fromHexToString((String)transaction.getValue());
        AccountMetadataTransactionFactory factory = AccountMetadataTransactionFactory.create((NetworkType)networkType, (UnresolvedAddress)targetAddress, (BigInteger)scopedMetaDataKey, (String)value);
        factory.valueSizeDelta(valueSizeDelta.intValue());
        Long valueSize = transaction.getValueSize();
        if (valueSize != null) {
            factory.valueSize(valueSize.longValue());
        }
        return factory;
    }

    @Override
    protected void copyToDto(AccountMetadataTransaction transaction, AccountMetadataTransactionDTO dto) {
        dto.setTargetAddress(transaction.getTargetAddress().encoded(transaction.getNetworkType()));
        dto.setValueSizeDelta(Integer.valueOf(transaction.getValueSizeDelta()));
        dto.setScopedMetadataKey(MapperUtils.fromBigIntegerToHex((BigInteger)transaction.getScopedMetadataKey()));
        dto.setValue(ConvertUtils.fromStringToHex((String)transaction.getValue()));
        dto.setValueSize(Long.valueOf(transaction.getValueSize()));
    }
}

