/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.Key;
import io.nem.symbol.sdk.infrastructure.TransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionMetaDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionMetaDTO;
import java.math.BigInteger;

public abstract class AbstractTransactionMapper<D, T extends Transaction>
implements TransactionMapper {
    private final TransactionType transactionType;
    private final JsonHelper jsonHelper;
    private final Class<D> transactionDtoClass;

    public AbstractTransactionMapper(JsonHelper jsonHelper, TransactionType transactionType, Class<D> transactionDtoClass) {
        this.jsonHelper = jsonHelper;
        this.transactionType = transactionType;
        this.transactionDtoClass = transactionDtoClass;
    }

    public Transaction mapFromDto(Object object) {
        return this.mapToFactoryFromDto(object).build();
    }

    public TransactionFactory<T> mapToFactoryFromDto(Object object) {
        if (object instanceof EmbeddedTransactionInfoDTO) {
            EmbeddedTransactionInfoDTO transactionInfoDTO = (EmbeddedTransactionInfoDTO)object;
            TransactionInfo transactionInfo = this.createTransactionInfo(transactionInfoDTO.getMeta(), transactionInfoDTO.getId());
            return this.createFactory(transactionInfo, transactionInfoDTO.getTransaction());
        }
        TransactionInfoDTO transactionInfoDTO = (TransactionInfoDTO)this.jsonHelper.convert(object, TransactionInfoDTO.class, new String[0]);
        TransactionInfo transactionInfo = this.createTransactionInfo(transactionInfoDTO.getMeta(), transactionInfoDTO.getId());
        return this.createFactory(transactionInfo, transactionInfoDTO.getTransaction());
    }

    protected TransactionInfo createTransactionInfo(Object meta, String id) {
        if (meta == null) {
            return null;
        }
        if (this.jsonHelper.contains(meta, new String[]{"aggregateHash"})) {
            EmbeddedTransactionMetaDTO embedded = (EmbeddedTransactionMetaDTO)this.jsonHelper.convert(meta, EmbeddedTransactionMetaDTO.class, new String[0]);
            return TransactionInfo.createAggregate((BigInteger)embedded.getHeight(), (Integer)embedded.getIndex(), (String)id, (String)embedded.getAggregateHash(), (String)embedded.getAggregateId());
        }
        TransactionMetaDTO toplevel = (TransactionMetaDTO)this.jsonHelper.convert(meta, TransactionMetaDTO.class, new String[0]);
        return TransactionInfo.create((BigInteger)toplevel.getHeight(), (Integer)toplevel.getIndex(), (String)id, (String)toplevel.getHash(), (String)toplevel.getMerkleComponentHash());
    }

    public Object mapToDto(Transaction transaction, Boolean embedded) {
        if (transaction.getTransactionInfo().flatMap(TransactionInfo::getAggregateHash).isPresent() || Boolean.TRUE.equals(embedded)) {
            EmbeddedTransactionInfoDTO dto = new EmbeddedTransactionInfoDTO();
            dto.setMeta(this.createTransactionInfoEmbedded(transaction));
            dto.setId((String)transaction.getRecordId().orElse(null));
            dto.setTransaction(this.mapTransaction(transaction, true));
            return dto;
        }
        TransactionInfoDTO dto = new TransactionInfoDTO();
        dto.setMeta((Object)this.createTransactionInfo(transaction));
        dto.setId((String)transaction.getRecordId().orElse(null));
        dto.setTransaction(this.mapTransaction(transaction, false));
        return dto;
    }

    protected final TransactionFactory<T> createFactory(TransactionInfo transactionInfo, Object transactionDto) {
        Object transaction = this.getJsonHelper().convert(transactionDto, this.transactionDtoClass, new String[0]);
        TransactionDTO transactionDTO = (TransactionDTO)this.getJsonHelper().convert(transactionDto, TransactionDTO.class, new String[0]);
        NetworkType networkType = NetworkType.rawValueOf((int)transactionDTO.getNetwork().getValue());
        TransactionFactory<T> factory = this.createFactory(networkType, transaction);
        factory.version(transactionDTO.getVersion());
        if (transactionDTO.getDeadline() != null) {
            factory.deadline(new Deadline(transactionDTO.getDeadline()));
        }
        if (transactionDTO.getSignerPublicKey() != null) {
            factory.signer(PublicAccount.createFromPublicKey((String)transactionDTO.getSignerPublicKey(), (NetworkType)networkType));
        }
        if (transactionDTO.getSignature() != null) {
            factory.signature(transactionDTO.getSignature());
        }
        if (transactionDTO.getMaxFee() != null) {
            factory.maxFee(transactionDTO.getMaxFee());
        }
        if (transactionDTO.getSize() != null) {
            factory.size(transactionDTO.getSize().longValue());
        }
        if (transactionInfo != null) {
            factory.transactionInfo(transactionInfo);
        }
        if (factory.getType() != this.getTransactionType()) {
            throw new IllegalStateException("Expected transaction to be " + this.getTransactionType() + " but got " + factory.getType());
        }
        return factory;
    }

    protected abstract TransactionFactory<T> createFactory(NetworkType var1, D var2);

    private EmbeddedTransactionMetaDTO createTransactionInfoEmbedded(Transaction transaction) {
        return transaction.getTransactionInfo().map(i -> {
            EmbeddedTransactionMetaDTO dto = new EmbeddedTransactionMetaDTO();
            dto.setHeight(i.getHeight());
            dto.setAggregateHash((String)i.getAggregateHash().orElse(null));
            dto.setIndex((Integer)i.getIndex().orElse(null));
            dto.setAggregateId((String)i.getAggregateId().orElse(null));
            return dto;
        }).orElse(null);
    }

    private TransactionMetaDTO createTransactionInfo(Transaction transaction) {
        return transaction.getTransactionInfo().map(i -> {
            TransactionMetaDTO dto = new TransactionMetaDTO();
            dto.setHeight(i.getHeight());
            dto.setHash((String)i.getHash().orElse(null));
            dto.setIndex((Integer)i.getIndex().orElse(null));
            dto.setMerkleComponentHash((String)i.getMerkleComponentHash().orElse(null));
            return dto;
        }).orElse(null);
    }

    private D mapTransaction(Transaction transaction, boolean embedded) {
        TransactionDTO dto = new TransactionDTO();
        dto.setSignerPublicKey((String)transaction.getSigner().map(PublicAccount::getPublicKey).map(Key::toHex).orElse(null));
        dto.setVersion(transaction.getVersion());
        dto.setType(Integer.valueOf(transaction.getType().getValue()));
        dto.setNetwork(NetworkTypeEnum.fromValue((Integer)transaction.getNetworkType().getValue()));
        if (!embedded) {
            dto.setSize(Long.valueOf(transaction.getSize()));
            dto.setMaxFee(transaction.getMaxFee());
            dto.setDeadline(transaction.getDeadline().toBigInteger());
            dto.setSignature((String)transaction.getSignature().orElse(null));
        }
        Object specificDto = this.getJsonHelper().parse(this.getJsonHelper().print((Object)dto), this.transactionDtoClass);
        this.copyToDto(transaction, specificDto);
        return (D)specificDto;
    }

    protected abstract void copyToDto(T var1, D var2);

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }
}

