/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.RestrictionAccountRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.AccountRestriction;
import io.nem.symbol.sdk.model.account.AccountRestrictions;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionTargetType;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RestrictionAccountRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements RestrictionAccountRepository {
    private final RestrictionAccountRoutesApi client;

    public RestrictionAccountRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new RestrictionAccountRoutesApiImpl(apiClient);
    }

    public Observable<AccountRestrictions> getAccountRestrictions(Address address) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getAccountRestrictions(address.plain(), handler)).map(AccountRestrictionsInfoDTO::getAccountRestrictions).map(this::toAccountRestrictions));
    }

    public Observable<List<AccountRestrictions>> getAccountsRestrictions(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountsRestrictions(accountIds);
    }

    private Observable<List<AccountRestrictions>> getAccountsRestrictions(AccountIds accountIds) {
        return this.exceptionHandling(this.call(handler -> this.getClient().getAccountRestrictionsFromAccounts(accountIds, handler)).flatMapIterable(item -> item).map(AccountRestrictionsInfoDTO::getAccountRestrictions).map(this::toAccountRestrictions)).toList().toObservable();
    }

    private AccountRestrictions toAccountRestrictions(AccountRestrictionsDTO dto) {
        return new AccountRestrictions(MapperUtils.toAddress((String)dto.getAddress()), dto.getRestrictions().stream().map(this::toAccountRestriction).collect(Collectors.toList()));
    }

    private AccountRestriction toAccountRestriction(AccountRestrictionDTO dto) {
        AccountRestrictionFlags restrictionFlags = AccountRestrictionFlags.rawValueOf((int)dto.getRestrictionFlags().getValue());
        return new AccountRestriction(restrictionFlags, dto.getValues().stream().filter(Objects::nonNull).map(Object::toString).map(arg_0 -> ((AccountRestrictionTargetType)restrictionFlags.getTargetType()).fromString(arg_0)).collect(Collectors.toList()));
    }

    public RestrictionAccountRoutesApi getClient() {
        return this.client;
    }
}

